/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.notifycenter.remoteimpl;

import cn.com.duiba.constant.DelayNotifyConfig;
import cn.com.duiba.constant.SkipNotifyConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.mq.RocketMQTopicConstant;
import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.thirdparty.api.RemoteNotifyDeveloperService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.thirdparty.enums.DelayMsgConfigNameEnum;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteNotifyQueueServiceImpl
implements RemoteNotifyDeveloperService {
    private static Logger log = LoggerFactory.getLogger(RemoteNotifyQueueServiceImpl.class);
    @Autowired
    private NotifyQueueDAO notifyQueueDAO;
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private SkipNotifyConfig skipNotifyConfig;
    @Autowired
    private DelayNotifyConfig delayNotifyConfig;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;
    @Autowired
    private RocketMQTopicConstant rocketMQTopicConstant;

    public void notifyDeveloper(NotifyQueueDto notifyQueue) {
        try {
            if (this.skipNotifyConfig.hasNotNotify(notifyQueue.getAppId(), notifyQueue.getResult())) {
                log.info("the app skip notify, appId={}", (Object)notifyQueue.getAppId());
                return;
            }
            NotifyQueueDO queue = (NotifyQueueDO)BeanUtils.copy((Object)notifyQueue, NotifyQueueDO.class);
            DBTimeProfile.enter((String)"insert");
            if (queue.getTimes() == null) {
                queue.setTimes(0);
            }
            if (queue.getNotifyType() == null) {
                queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
            }
            if (NotifyTypeEnum.getByCode((Integer)queue.getNotifyType()) == null) {
                throw new Exception("\u901a\u77e5\u7c7b\u578b\u4e0d\u5b58\u5728;queue:" + JSON.toJSONString((Object)queue));
            }
            String errorMsg = queue.getError4developer();
            if (StringUtils.isNotBlank((String)errorMsg) && errorMsg.length() > 600) {
                queue.setError4developer(errorMsg.substring(0, 600));
            }
            if (this.delayNotifyConfig.ifNeedDelay(queue.getAppId())) {
                log.info("[\u4e07\u8fbe\u9152\u5e97] remote\u5ef6\u65f6\u53d1\u9001");
                JSONObject json = (JSONObject)JSONObject.toJSON((Object)queue);
                Integer delayLevel = Optional.ofNullable(DelayNotifyConfig.getDelayLevels(queue.getAppId())).orElse(0);
                json.put(DelayMsgConfigNameEnum.DELAY_LEVEL.getName(), (Object)delayLevel);
                this.rocketMQMsgProducer.sendMsg(this.rocketMQTopicConstant.getDelayMsg(), "remote", "", json.toJSONString(), false, null);
                DBTimeProfile.release();
                return;
            }
            this.notifyQueueDAO.insert(queue);
            DBTimeProfile.release();
            DBTimeProfile.enter((String)"notify");
            this.notifyService.notify(queue, "remote call");
            DBTimeProfile.release();
        }
        catch (Exception e) {
            log.error("notify error", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        String url = "https://ecomm.generalichina.com/testapi/credit/third/duiba/minusintegral?actualPrice=0&ip=221.12.18.35&itemCode=123&sign=170ed0ab251727f9c9ea938a8b01fb8f&description={\"channel\":1,\"count\":1,\"detail\":[{\"amount\":1,\"name\":\"\u5151\u6362\u5b9e\u7269\uff1a\u6263\u79ef\u5206\u6d4b\u8bd5\",\"originPrice\":1,\"price\":1}],\"sn\":\"181341282116202C0817\",\"userId\":\"00000035\"}&orderNum=181341282116202C0817&waitAudit=false&type=object&params=\u6d4b\u8bd5:13078788989:\u5317\u4eac\u5e02:\u5317\u4eac\u5e02:\u4e1c\u57ce\u533a:\u4e1c\u534e\u95e8\u8857\u9053:\u6d4b\u8bd5&uid=00000035&credits=1&facePrice=100&appKey=3n5TgKxmMy1kYhuddr2K84o1YyHm&timestamp=1636426459026&";
        Map<String, String> urlParams = AssembleTool.getUrlParams(url.substring(url.indexOf("?") + 1));
        urlParams.remove("sign");
        urlParams.put("appSecret", "eEC4FbTJmKvqrufjAGLna1MTs6J");
        System.out.println(urlParams.toString());
        String sign = SignTool.sign(urlParams);
        System.out.println("sign:" + sign);
        urlParams.put("sign", sign);
        System.out.println(urlParams.toString());
    }
}

