/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.notifycenter.service.impl;

import cn.com.duiba.constant.shoppingTrolley.ShoppingTrolleyConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.AppNewExtraDao;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.BussinessTypesService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.SlowRequestHandler;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.UrlUtils;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bussinessTypesService")
public class BusinessTypeServiceImpl
implements BussinessTypesService {
    private static Logger log = LoggerFactory.getLogger(BusinessTypeServiceImpl.class);
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private CustomService customService;
    @Autowired
    private AppNewExtraDao appNewExtraDao;
    @Autowired
    private SlowRequestHandler slowRequestHandler;
    @Autowired
    private ShoppingTrolleyConfig shoppingTrolleyConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpUriRequest getRequest(NotifyQueueDO record) {
        try {
            DBTimeProfile.enter((String)"getRequest");
            if (Objects.equals(record.getNotifyType(), NotifyTypeEnum.NOTIFY_PAY.getCode())) {
                HttpUriRequest httpUriRequest = this.getPayRequest(record);
                return httpUriRequest;
            }
            if (Objects.equals(record.getNotifyType(), NotifyTypeEnum.NOTIFY_OBJECT_SEND.getCode())) {
                HttpUriRequest httpUriRequest = this.getObjectSendRequest(record);
                return httpUriRequest;
            }
            if (Objects.equals(record.getNotifyType(), NotifyTypeEnum.NOTIFY_POSTSALE.getCode())) {
                HttpUriRequest httpUriRequest = this.getPostsaleNotifyRequest(record);
                return httpUriRequest;
            }
            if ("reSignCard".equals(record.getRelationType())) {
                HttpUriRequest httpUriRequest = this.getReSignRequest(record);
                return httpUriRequest;
            }
            HttpUriRequest httpUriRequest = this.getCreditsRequest(record);
            if (httpUriRequest == null) {
                HttpUriRequest httpUriRequest2 = null;
                return httpUriRequest2;
            }
            String reqUrl = UrlUtils.buildUrl(httpUriRequest.getURI());
            if (this.slowRequestHandler.isBlackHost(reqUrl)) {
                log.info("{} is black host*****", (Object)reqUrl);
                HttpUriRequest httpUriRequest3 = null;
                return httpUriRequest3;
            }
            HttpUriRequest httpUriRequest4 = httpUriRequest;
            return httpUriRequest4;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private HttpUriRequest getPostsaleNotifyRequest(NotifyQueueDO record) {
        AppDO app = this.appDAO.getAppByCache(record.getAppId());
        if (app == null) {
            throw new IllegalStateException("app info\u4e3a\u7a7a");
        }
        String url = this.appNewExtraDao.findPostsaleNotify(record.getAppId());
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String paramStr = null;
        if (StringUtils.isBlank((String)record.getError4developer())) {
            log.warn("\u5b8c\u6210\u552e\u540e\u901a\u77e5\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a\uff0cappId\uff1a{},\u901a\u77e5\u8bb0\u5f55Id:{}\uff0c\u8ba2\u5355\u53f7\uff1a{}", new Object[]{record.getAppId(), record.getId(), record.getDuibaOrderNum()});
            return null;
        }
        paramStr = record.getError4developer();
        Map<String, String> map = this.buildPostsaleNotifyMap(record, paramStr, app);
        HttpGet request = new HttpGet(AssembleTool.assembleUrl(url, map));
        request.setConfig(this.getDefaultConfig());
        return request;
    }

    private Map<String, String> buildPostsaleNotifyMap(NotifyQueueDO record, String paramStr, AppDO app) {
        com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)paramStr);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appKey", app.getAppKey());
        map.put("uid", this.getString(record.getPartnerUserId()));
        map.put("timestamp", System.currentTimeMillis() + "");
        map.put("orderNum", this.getString(record.getDuibaOrderNum()));
        if (StringUtils.isNotBlank((String)this.getString(record.getDeveloperBizId()))) {
            map.put("bizId", this.getString(record.getDeveloperBizId()));
        }
        map.put("totalAmount", jsonObject.getString("totalAmount"));
        map.put("freightAmount", jsonObject.getString("freightAmount"));
        map.put("totalCredits", jsonObject.getString("totalCredits"));
        map.put("realPayAmount", jsonObject.getString("realPayAmount"));
        map.put("realPayCredits", jsonObject.getString("realPayCredits"));
        map.put("refundAmount", jsonObject.getString("refundAmount"));
        map.put("appSecret", this.appDAO.getAppSecret(app));
        if (StringUtils.isNotBlank((String)record.getTransfer())) {
            map.put("transfer", record.getTransfer());
        }
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }

    private HttpUriRequest getCreditsRequest(NotifyQueueDO record) {
        HttpRequestBase customRequest;
        String uid;
        AppDO app = this.appDAO.getAppByCache(record.getAppId());
        if (app == null) {
            throw new IllegalStateException("app info\u4e3a\u7a7a");
        }
        if (app.getCreditsConsumeNotifyUrl() == null || app.getCreditsConsumeNotifyUrl().length() == 0) {
            return null;
        }
        String errorMessage = "";
        if (record.getError4developer() != null) {
            errorMessage = record.getError4developer();
        }
        if ((uid = record.getPartnerUserId()) == null) {
            uid = "";
        }
        String bizId = "";
        if (record.getDeveloperBizId() != null) {
            bizId = record.getDeveloperBizId();
        }
        CreditNotifyParams p = new CreditNotifyParams();
        p.setSuccess(record.getResult().booleanValue());
        p.setErrorMessage(errorMessage);
        p.setAppKey(app.getAppKey());
        p.setBizId(bizId);
        p.setUid(uid);
        p.setOrderNum(record.getDuibaOrderNum());
        String time = "";
        if (this.customService.isMobike(app.getId())) {
            time = String.valueOf(new Date().getTime() / 1000L);
        }
        if ((customRequest = this.customService.getRequestNotify(app.getCreditsConsumeNotifyUrl(), record, time, app, p)) != null) {
            customRequest.setConfig(this.getDefaultConfig());
            return customRequest;
        }
        String transfer = record.getTransfer();
        Map<String, String> map = StringUtils.isNotBlank((String)transfer) ? this.customService.toRequestMapWithTransfer(this.appDAO.getAppSecret(app), p, transfer, uid) : p.toRequestMap(this.appDAO.getAppSecret(app));
        if (this.shoppingTrolleyConfig.checkAppId(record.getAppId()).booleanValue() && record.getRollbackCredits() != null) {
            map.put("rollbackCredits", String.valueOf(record.getRollbackCredits()));
        }
        Object request = this.customService.isPostApp(app.getId()) ? this.assembleRequest(app.getCreditsConsumeNotifyUrl(), map) : (this.customService.isPayqb(app.getId()) ? this.assemblePostRequestForJson(app.getCreditsConsumeNotifyUrl(), map) : new HttpGet(AssembleTool.assembleUrl(app.getCreditsConsumeNotifyUrl(), map)));
        request.setConfig(this.getDefaultConfig());
        return request;
    }

    private HttpRequestBase assemblePostRequestForJson(String url, Map<String, String> params) {
        HttpPost post = new HttpPost(url);
        try {
            JSONObject jsonObject = JSONObject.fromObject(params);
            String json = jsonObject.toString();
            StringEntity postingString = new StringEntity(json, Charset.forName("utf-8"));
            post.setHeader("Content-Type", "application/json");
            post.setEntity((HttpEntity)postingString);
        }
        catch (Exception e) {
            log.error("BusinessTypeServiceImpl call assembleRequestForRaw error,url = {},params = {}", new Object[]{url, com.alibaba.fastjson.JSONObject.toJSONString(params), e});
        }
        return post;
    }

    private HttpUriRequest getReSignRequest(NotifyQueueDO record) {
        DBTimeProfile.enter((String)"getReSignRequest");
        AppDO app = this.appDAO.getAppByCache(record.getAppId());
        String url = this.appNewExtraDao.findVirtualCardConsumeNotify(record.getAppId());
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String errorMessage = record.getError4developer();
        String uid = record.getPartnerUserId();
        String bizId = record.getDeveloperBizId();
        CreditNotifyParams p = new CreditNotifyParams();
        p.setSuccess(record.getResult().booleanValue());
        p.setErrorMessage(errorMessage == null ? "" : errorMessage);
        p.setAppKey(app.getAppKey());
        p.setBizId(bizId == null ? "" : bizId);
        p.setUid(uid == null ? "" : uid);
        p.setOrderNum(record.getDuibaOrderNum());
        Map map = p.toRequestMap(this.appDAO.getAppSecret(app));
        HttpGet request = new HttpGet(AssembleTool.assembleUrl(url, map));
        request.setConfig(this.getDefaultConfig());
        return request;
    }

    private HttpUriRequest getPayRequest(NotifyQueueDO record) {
        String uid;
        AppDO app = this.appDAO.getAppByCache(record.getAppId());
        if (!this.customService.isAlisports(app.getId())) {
            return null;
        }
        String notifyUrl = "http://sportsbank.taobao.com/credit/rmbPayment";
        String errorMessage = "";
        if (record.getError4developer() != null) {
            errorMessage = record.getError4developer();
        }
        if ((uid = record.getPartnerUserId()) == null) {
            uid = "";
        }
        String bizId = "";
        if (record.getDeveloperBizId() != null) {
            bizId = record.getDeveloperBizId();
        }
        CreditNotifyParams p = new CreditNotifyParams();
        p.setSuccess(record.getResult().booleanValue());
        p.setErrorMessage(errorMessage);
        p.setAppKey(app.getAppKey());
        p.setBizId(bizId);
        p.setUid(uid);
        p.setOrderNum(record.getDuibaOrderNum());
        Map map = p.toRequestMap(this.appDAO.getAppSecret(app));
        String url = AssembleTool.assembleUrl(notifyUrl, map);
        HttpGet request = new HttpGet(url);
        request.setConfig(this.getDefaultConfig());
        return request;
    }

    private HttpUriRequest getObjectSendRequest(NotifyQueueDO record) {
        String url = this.appNewExtraDao.findDeliverObjectOrderNotify(record.getAppId());
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        AppDO app = this.appDAO.getAppByCache(record.getAppId());
        String errorMessage = record.getError4developer();
        String uid = record.getPartnerUserId();
        String bizId = record.getDeveloperBizId();
        CreditNotifyParams p = new CreditNotifyParams();
        p.setSuccess(record.getResult().booleanValue());
        p.setErrorMessage(errorMessage == null ? "" : errorMessage);
        p.setAppKey(app.getAppKey());
        p.setBizId(bizId == null ? "" : bizId);
        p.setUid(uid == null ? "" : uid);
        p.setOrderNum(record.getDuibaOrderNum());
        Map map = p.toRequestMap(this.appDAO.getAppSecret(app));
        String transfer = record.getTransfer();
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)transfer);
        String goodsId = jsonObject.getString("gid");
        String goodsName = jsonObject.getString("gName");
        String expressId = jsonObject.getString("eid");
        String expressName = jsonObject.getString("eName");
        if (StringUtils.isNotBlank((String)goodsId)) {
            map.put("goodsId", goodsId);
        }
        if (StringUtils.isNotBlank((String)goodsName)) {
            map.put("goodsName", goodsName);
        }
        map.put("expressId", expressId == null ? "" : expressId);
        map.put("expressName", expressName == null ? "" : expressName);
        HttpGet request = new HttpGet(AssembleTool.assembleUrl(url, map));
        request.setConfig(this.getDefaultConfig());
        return request;
    }

    private RequestConfig getDefaultConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }

    public HttpPost assembleRequest(String url, Map<String, String> params) {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair(entry.getKey(), value));
        }
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName("utf-8")));
        return post;
    }
}

