/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.virtualcard.VirtualCard4Devloper;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.RemoteVirtualCardService;
import cn.com.duiba.thirdparty.dto.VirtualCardMessage;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteVirtualCardServiceImpl
implements RemoteVirtualCardService {
    private static Logger logger = LoggerFactory.getLogger(RemoteVirtualCardServiceImpl.class);
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private VirtualCard4Devloper virtualCard4Devloper;

    public DubboResult<Boolean> submitSubVirtualCard(VirtualCardMessage request, String msgTopic, String msgTag, String msgKey) {
        try {
            this.validParam(request, msgTopic);
            this.virtualCard4Devloper.submit(request, msgTopic, msgTag, msgKey);
            return DubboResult.successResult((Object)true);
        }
        catch (CodeException e) {
            logger.info("\u63d0\u4ea4\u6263\u865a\u62df\u5361\u4efb\u52a1\u5931\u8d25, errMsg={}", (Object)e.getMessage());
            logger.debug("\u63d0\u4ea4\u6263\u865a\u62df\u5361\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u6263\u865a\u62df\u5361\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    private void validParam(VirtualCardMessage request, String msgTopic) {
        if (StringUtils.isBlank((String)msgTopic)) {
            throw new CodeException(ErrorCode.E0001001.getErrorCode(), "\u8ba2\u9605topic\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)request.getHttpUrl())) {
            throw new CodeException(ErrorCode.E0001001.getErrorCode(), "\u8bf7\u6c42URL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getAppId() == null) {
            throw new CodeException(ErrorCode.E0001001.getErrorCode(), "APPID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.httpAsyncClientPool.canSubmitToAppPool(request.getAppId())) {
            throw new CodeException(ErrorCode.E0001001.getErrorCode(), "\u5f00\u53d1\u8005\u63a5\u53e3\u7e41\u5fd9, appId: " + request.getAppId());
        }
    }
}

