/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.boc;

import cn.com.duiba.config.FuJianBocConfig;
import cn.com.duiba.thirdparty.api.boc.RemoteFjBocService;
import cn.com.duiba.thirdparty.dto.boc.IdentityDataDto;
import cn.com.duiba.thirdparty.dto.boc.LabelDataReqParam;
import cn.com.duiba.thirdparty.dto.boc.PublicDataReqParam;
import cn.com.duiba.thirdparty.dto.boc.UnionNoReqParam;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.boc.ConverTool;
import cn.com.duiba.tool.boc.SM3;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteFjBocServiceImpl
implements RemoteFjBocService {
    private static Logger log = LoggerFactory.getLogger(RemoteFjBocServiceImpl.class);
    private static final String DUIBA_DATA_UPLOAD_PATH = "/unlogin/fjtj/duibaDataUpload";
    private static final String WX_DATA_URL_PATH = "/unlogin/fjtj/wxdata";
    private static final String LABEL_DATA_URL_PATH = "/unlogin/fjtj/labeldata";
    private static final String GET_UNION_ON_URL_PATH = "/unlogin/fjtj/getunionno";
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    @Resource
    private FuJianBocConfig fuJianBocConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public JSONObject duibaDataUpload(List<IdentityDataDto> dataDtoList) throws IOException {
        List jsonObjectList = dataDtoList.stream().map(identityDataDto -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("openid", (Object)identityDataDto.getOpenId());
            jsonObject.put("mobile", (Object)identityDataDto.getMobile());
            jsonObject.put("union_no", (Object)identityDataDto.getUnionNo());
            return jsonObject;
        }).collect(Collectors.toList());
        JSONObject paramJsonObject = new JSONObject();
        paramJsonObject.put("datalist", jsonObjectList);
        paramJsonObject.put("appid", (Object)this.fuJianBocConfig.getAppId());
        paramJsonObject.put("appsecret", (Object)this.fuJianBocConfig.getAppSecret());
        String url = this.fuJianBocConfig.getUrl() + DUIBA_DATA_UPLOAD_PATH;
        String jsonStr = JSONObject.toJSONString((Object)paramJsonObject);
        log.info("\u798f\u5efa\u4e2d\u884c\u5b9e\u540d\u6570\u636e\u6279\u91cf\u4e0a\u9001,data:{}", (Object)jsonStr);
        JSONObject jsonObject = this.sendRequest(jsonStr, url, HttpMethod.POST);
        if (null == jsonObject) {
            return new JSONObject();
        }
        return this.assembleResult(jsonObject);
    }

    public JSONObject wxDataExport(PublicDataReqParam publicDataReqParam) throws IOException {
        String url;
        String jsonStr = JSON.toJSONString((Object)publicDataReqParam);
        JSONObject jsonObject = this.sendRequest(jsonStr, url = this.fuJianBocConfig.getUrl() + WX_DATA_URL_PATH, HttpMethod.POST);
        if (null == jsonObject) {
            return new JSONObject();
        }
        return this.assembleResult(jsonObject);
    }

    public JSONObject labelDataExport(LabelDataReqParam dataRerParam) throws IOException {
        String url;
        String jsonStr = JSON.toJSONString((Object)dataRerParam);
        JSONObject jsonObject = this.sendRequest(jsonStr, url = this.fuJianBocConfig.getUrl() + LABEL_DATA_URL_PATH, HttpMethod.POST);
        if (null == jsonObject) {
            return new JSONObject();
        }
        return this.assembleResult(jsonObject);
    }

    public JSONObject getUnionNo(UnionNoReqParam reqParam) throws IOException {
        String url;
        String jsonStr = JSON.toJSONString((Object)reqParam);
        JSONObject jsonObject = this.sendRequest(jsonStr, url = this.fuJianBocConfig.getUrl() + GET_UNION_ON_URL_PATH, HttpMethod.POST);
        if (null == jsonObject) {
            return new JSONObject();
        }
        return this.assembleResult(jsonObject);
    }

    public String verifyUser(String openId) {
        String s = Base64.getEncoder().encodeToString(openId.getBytes());
        return this.fuJianBocConfig.getVerifyUserUrl() + "?openid=" + s;
    }

    private JSONObject sendRequest(String jsonStr, String urlPath, HttpMethod httpMethod) throws IOException {
        byte[] dataBytes = jsonStr.getBytes("UTF-8");
        String encResultData = this.getEncResultData(dataBytes);
        String signatureSign = this.getSignatureSign(dataBytes);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("encresult", (Object)encResultData);
        jsonObject.put("signdata", (Object)signatureSign);
        Map params = (Map)JSONObject.parseObject((String)jsonObject.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String res = "";
        if (httpMethod == HttpMethod.POST) {
            HttpPost httpPost = new HttpPost(urlPath);
            httpPost.setConfig(requestConfig);
            StringEntity se = new StringEntity(JSONObject.toJSONString((Object)params), "utf-8");
            httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
            log.info("\u798f\u5efa\u4e2d\u884c\u8bf7\u6c42\uff0crequestUrl\uff1a{}\uff0cparams\uff1a{}", (Object)urlPath, (Object)JSONObject.toJSONString((Object)params));
            httpPost.setEntity((HttpEntity)se);
            res = this.fjBocRequest((HttpUriRequest)httpPost);
        } else {
            String assembleUrl = AssembleTool.assembleUrl(urlPath, params);
            log.info("\u798f\u5efa\u4e2d\u884c-\u8bf7\u6c42url\uff0curl:{}", (Object)assembleUrl);
            HttpGet httpGet = new HttpGet(assembleUrl);
            httpGet.setConfig(requestConfig);
            res = this.fjBocRequest((HttpUriRequest)httpGet);
        }
        return JSONObject.parseObject((String)res);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fjBocRequest(HttpUriRequest httpRequest) {
        try (CloseableHttpResponse response = this.httpClient.execute(httpRequest);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u798f\u5efa\u4e2d\u884c\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            String string = responseStr;
            return string;
        }
        catch (Exception e) {
            log.warn("\u798f\u5efa\u4e2d\u884c\u54cd\u5e94\u5f02\u5e38\uff0curl:{},param:{}", new Object[]{httpRequest.getURI().getPath(), JSON.toJSONString((Object)httpRequest), e});
            return null;
        }
    }

    private String getEncResultData(byte[] dataBytes) {
        String shPublicKey = this.fuJianBocConfig.getSHPublicKey();
        if (shPublicKey.length() == 130) {
            shPublicKey = shPublicKey.substring(2);
        }
        String shxHex = shPublicKey.substring(0, 64);
        String shhyHex = shPublicKey.substring(64, 128);
        ECPublicKeyParameters ecPublicKeyParameters = BCUtil.toSm2Params((String)shxHex, (String)shhyHex);
        SM2 sm2 = new SM2(null, ecPublicKeyParameters);
        sm2.usePlainEncoding();
        sm2.setMode(SM2Engine.Mode.C1C2C3);
        byte[] encData = sm2.encrypt(dataBytes, KeyType.PublicKey);
        return ConverTool.parseByte2HexStr(encData);
    }

    private String getSignatureSign(byte[] dataBytes) throws IOException {
        String sm2SignTextData = SM3.byteArrayToHexString(SM3.hash(dataBytes)) + this.fuJianBocConfig.getAppId();
        byte[] sm2SignDataBytesData = sm2SignTextData.getBytes("UTF-8");
        ECPrivateKeyParameters privateKeyParameters = BCUtil.toSm2Params((String)this.fuJianBocConfig.getPTPrivateKeyHex());
        SM2 sm22 = new SM2(privateKeyParameters, null);
        sm22.usePlainEncoding();
        sm22.setMode(SM2Engine.Mode.C1C2C3);
        byte[] sign = sm22.sign(sm2SignDataBytesData, null);
        return HexUtil.encodeHexStr((byte[])sign);
    }

    private String decodeResult(String encResultData) throws UnsupportedEncodingException {
        ECPrivateKeyParameters ecPrivateKeyParameters = BCUtil.toSm2Params((String)this.fuJianBocConfig.getPTPrivateKeyHex());
        SM2 sm2pri = new SM2(ecPrivateKeyParameters, null);
        sm2pri.usePlainEncoding();
        sm2pri.setMode(SM2Engine.Mode.C1C2C3);
        byte[] decdata = sm2pri.decrypt(ConverTool.parseHexStr2Byte(encResultData), KeyType.PrivateKey);
        return new String(decdata, "UTF-8");
    }

    private boolean verifyResult(String decodeBody, String signatureSign) throws IOException {
        String shPublicKey = this.fuJianBocConfig.getSHPublicKey();
        if (shPublicKey.length() == 130) {
            shPublicKey = shPublicKey.substring(2);
        }
        String xhex = shPublicKey.substring(0, 64);
        String yhex = shPublicKey.substring(64, 128);
        ECPublicKeyParameters params = BCUtil.toSm2Params((String)xhex, (String)yhex);
        SM2 sm2b = new SM2(null, params);
        sm2b.usePlainEncoding();
        sm2b.setMode(SM2Engine.Mode.C1C2C3);
        String sm2signtext = SM3.byteArrayToHexString(SM3.hash(decodeBody.getBytes("UTF-8"))) + this.fuJianBocConfig.getSignInfo();
        byte[] sm2signdataBytes = sm2signtext.getBytes("UTF-8");
        return sm2b.verify(sm2signdataBytes, HexUtil.decodeHex((String)signatureSign));
    }

    private JSONObject assembleResult(JSONObject jsonObject) throws IOException {
        JSONObject result = new JSONObject();
        String decodeBody = "";
        if (!"0000".equals(jsonObject.getString("msgcde"))) {
            return jsonObject;
        }
        if (!jsonObject.containsKey((Object)"signdata")) {
            return jsonObject;
        }
        if (jsonObject.containsKey((Object)"encresult")) {
            String encresult = jsonObject.getString("encresult");
            decodeBody = this.decodeResult(encresult);
            result = JSON.parseObject((String)decodeBody);
            result.put("msgcde", (Object)jsonObject.getString("msgcde"));
        }
        if (StringUtils.isBlank((CharSequence)decodeBody) || !this.verifyResult(decodeBody, jsonObject.getString("signdata"))) {
            log.error("\u9a8c\u7b7e\u5931\u8d25");
            jsonObject.put("msgcode", (Object)"E0S");
            jsonObject.put("msg", (Object)"\u9a8c\u7b7e\u5931\u8d25,\u7b7e\u540d\u6570\u636e\u9519\u8bef");
            return jsonObject;
        }
        return result;
    }
}

