/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.mng;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.mng.NewMngConfig;
import cn.com.duiba.thirdparty.api.mng.RemoteNewMngService;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import cn.hutool.crypto.digest.DigestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteNewMngServiceImpl
implements RemoteNewMngService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteNewMngServiceImpl.class);
    private static final String NEW_MNG_ACCESS_TOKEN_GET = "NEW_MNG_ACCESS_TOKEN_GET";
    private static final String NEW_MNG_ACCESS_TOKEN_REFRESH = "NEW_MNG_ACCESS_TOKEN_REFRESH";
    private static final String NEW_MNG_ACCESS_TOKEN_REFRESHING = "NEW_MNG_ACCESS_TOKEN_REFRESHING";
    @CanAccessInsideNetwork
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @CanAccessInsideNetwork
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Autowired
    private NewMngConfig newMngConfig;

    public String getAccessToken() {
        if (this.redisTemplate.hasKey((Object)NEW_MNG_ACCESS_TOKEN_GET).booleanValue()) {
            return (String)this.redisTemplate.opsForValue().get((Object)NEW_MNG_ACCESS_TOKEN_GET);
        }
        if (this.redisTemplate.hasKey((Object)NEW_MNG_ACCESS_TOKEN_REFRESH).booleanValue()) {
            return this.refreshAccessToken();
        }
        return this.getAccessToken(Maps.newHashMap(), this.newMngConfig.getGetAccessTokenUrl());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAccessToken(Map<String, Object> params, String url) {
        HttpPost post = new HttpPost(url);
        long curTimestamp = System.currentTimeMillis();
        String sourceValue = this.newMngConfig.getAppKey() + ":" + this.newMngConfig.getAppSecret() + ":" + curTimestamp;
        String sign = DigestUtil.md5Hex((String)sourceValue).toUpperCase();
        params.put("appKey", this.newMngConfig.getAppKey());
        params.put("sign", sign);
        params.put("timestamp", curTimestamp);
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params), "UTF-8"));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.info("\u65b0\u4f9b\u5e94\u5546\u83b7\u53d6/\u5237\u65b0accessToken\u54cd\u5e94\uff0cresponse:{}", (Object)responseStr);
            JSONObject resp = JSON.parseObject((String)responseStr);
            Boolean success = resp.getBoolean("success");
            if (!success.booleanValue()) {
                throw new BizException("\u65b0\u4f9b\u5e94\u5546\u54cd\u5e94\u5f02\u5e38");
            }
            JSONObject result = resp.getJSONObject("result");
            String accessToken = result.getString("access_token");
            String refreshToken = result.getString("refresh_token");
            if (StringUtils.isBlank((String)accessToken)) throw new BizException("\u65b0\u4f9b\u5e94\u5546\u54cd\u5e94token\u4e3a\u7a7a");
            if (StringUtils.isBlank((String)refreshToken)) {
                throw new BizException("\u65b0\u4f9b\u5e94\u5546\u54cd\u5e94token\u4e3a\u7a7a");
            }
            HashMap tokenCache = Maps.newHashMap();
            tokenCache.put("accessToken", accessToken);
            tokenCache.put("refreshToken", refreshToken);
            this.redisTemplate.opsForValue().set((Object)NEW_MNG_ACCESS_TOKEN_GET, (Object)accessToken, 90L, TimeUnit.MINUTES);
            this.redisTemplate.opsForValue().set((Object)NEW_MNG_ACCESS_TOKEN_REFRESH, (Object)JSON.toJSONString((Object)tokenCache), 2L, TimeUnit.HOURS);
            String string = accessToken;
            return string;
        }
        catch (Exception e) {
            LOGGER.warn("\u65b0\u4f9b\u5e94\u5546\u83b7\u53d6/\u5237\u65b0accessToken\u5f02\u5e38\uff0cparams\uff1a{}", (Object)JSON.toJSONString(params), (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String refreshAccessToken() {
        if (this.redisTemplate.hasKey((Object)NEW_MNG_ACCESS_TOKEN_GET).booleanValue()) {
            return (String)this.redisTemplate.opsForValue().get((Object)NEW_MNG_ACCESS_TOKEN_GET);
        }
        String tokenCache = (String)this.redisTemplate.opsForValue().get((Object)NEW_MNG_ACCESS_TOKEN_REFRESH);
        JSONObject jsonObject = JSON.parseObject((String)tokenCache);
        String accessToken = jsonObject.getString("accessToken");
        String refreshToken = jsonObject.getString("refreshToken");
        try (RedisLock redisLock = this.redisAtomicClient.getLock(NEW_MNG_ACCESS_TOKEN_REFRESHING, 5L);){
            if (redisLock == null) {
                LOGGER.info("\u65b0\u4f9b\u5e94\u5546\u5237\u65b0accessToken\u4e2d\uff0c\u8fd4\u56de\u8001token\uff0cparams\uff1a{}", (Object)accessToken);
                String string2 = accessToken;
                return string2;
            }
            HashMap params = Maps.newHashMap();
            params.put("refreshToken", refreshToken);
            String string = this.getAccessToken(params, this.newMngConfig.getRefreshAccessTokenUrl());
            return string;
        }
        catch (Exception e) {
            LOGGER.warn("\u65b0\u4f9b\u5e94\u5546\u5237\u65b0accessToken\u5f02\u5e38\uff0crefreshToken\uff1a{}, accessToken:{}", new Object[]{refreshToken, accessToken, e});
            return accessToken;
        }
    }
}

