/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.cgb;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.params.KeyParameter;

public class SM4Util {
    private static final int SM4_ENCRYPT = 1;
    private static final int SM4_DECRYPT = 0;
    public static final int SM4_PKCS8PADDING = 1;
    public static final int SM4_NOPADDING = 0;
    public static final int SM4_KEY_128 = 128;

    public static byte[] generateKey(int keySize) {
        byte[] key = new byte[keySize / 8];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(key);
        return key;
    }

    public static byte[] encryptECB(byte[] data, byte[] key) {
        return SM4Util.encryptECB(data, key, 1);
    }

    public static byte[] decryptECB(byte[] cipher, byte[] key) {
        return SM4Util.decryptECB(cipher, key, 1);
    }

    public static byte[] encryptCBC(byte[] data, byte[] key, byte[] iv) {
        return SM4Util.encryptCBC(data, key, iv, 1);
    }

    public static byte[] decryptCBC(byte[] cipher, byte[] key, byte[] iv) {
        return SM4Util.decryptCBC(cipher, key, iv, 1);
    }

    public static byte[] encryptECB(byte[] data, byte[] key, int paddingMode) {
        SM4Engine engine = new SM4Engine();
        engine.init(true, (CipherParameters)new KeyParameter(key));
        data = paddingMode == 1 ? SM4Util.padding(data, 1) : (byte[])data.clone();
        int length = data.length;
        int i = 0;
        while (length > 0) {
            engine.processBlock(data, i, data, i);
            length -= 16;
            i += 16;
        }
        return data;
    }

    public static byte[] decryptECB(byte[] cipher, byte[] key, int paddingMode) {
        SM4Engine engine = new SM4Engine();
        engine.init(false, (CipherParameters)new KeyParameter(key));
        int length = cipher.length;
        byte[] tmp = new byte[cipher.length];
        int i = 0;
        while (length > 0) {
            engine.processBlock(cipher, i, tmp, i);
            length -= 16;
            i += 16;
        }
        byte[] plain = null;
        plain = paddingMode == 1 ? SM4Util.padding(tmp, 0) : tmp;
        return plain;
    }

    public static byte[] encryptCBC(byte[] data, byte[] key, byte[] iv, int paddingMode) {
        SM4Engine engine = new SM4Engine();
        engine.init(true, (CipherParameters)new KeyParameter(key));
        data = paddingMode == 1 ? SM4Util.padding(data, 1) : (byte[])data.clone();
        int length = data.length;
        iv = (byte[])iv.clone();
        int i = 0;
        while (length > 0) {
            for (int j = 0; j < 16; ++j) {
                data[i + j] = (byte)(data[i + j] ^ iv[j]);
            }
            engine.processBlock(data, i, data, i);
            System.arraycopy(data, i, iv, 0, 16);
            length -= 16;
            i += 16;
        }
        return data;
    }

    public static byte[] decryptCBC(byte[] cipher, byte[] key, byte[] iv, int paddingMode) {
        SM4Engine engine = new SM4Engine();
        engine.init(false, (CipherParameters)new KeyParameter(key));
        int length = cipher.length;
        byte[] plain = new byte[cipher.length];
        iv = (byte[])iv.clone();
        int i = 0;
        while (length > 0) {
            engine.processBlock(cipher, i, plain, i);
            for (int j = 0; j < 16; ++j) {
                plain[j + i] = (byte)(plain[i + j] ^ iv[j]);
            }
            System.arraycopy(cipher, i, iv, 0, 16);
            length -= 16;
            i += 16;
        }
        byte[] res = null;
        res = paddingMode == 1 ? SM4Util.padding(plain, 0) : plain;
        return res;
    }

    private static byte[] padding(byte[] input, int mode) {
        if (input == null) {
            return null;
        }
        byte[] ret = null;
        if (mode == 1) {
            int p = 16 - input.length % 16;
            ret = new byte[input.length + p];
            System.arraycopy(input, 0, ret, 0, input.length);
            for (int i = 0; i < p; ++i) {
                ret[input.length + i] = (byte)p;
            }
        } else {
            byte p = input[input.length - 1];
            ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
        }
        return ret;
    }
}

