/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.hsbc;

import cn.com.duiba.constant.hsbc.HsbcConfig;
import cn.com.duiba.consumer.center.api.dto.ConsumerExtraDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerExtraService;
import cn.com.duiba.tool.hsbc.SignUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Jwts;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class HsbcTool {
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static final String AES_PADDING_MODE = "AES/CBC/PKCS5Padding";
    private static final String RSA_PADDING_MODE = "RSA/ECB/PKCS1Padding";
    private static final String ALGORITHM_AES = "AES";
    private static final String JWT_TOKEN_PREFIX = "JWS ";
    private static final int DUIBA_RSA_MAX_ENCRYPT_LEN = 245;
    private static final int HSBC_RSA_MAX_DECRYPT_LEN = 256;
    private static final int VECTOR_LENGTH = 16;
    private static final int KEY_LENGTH = 256;
    @Resource
    private HsbcConfig hsbcConfig;
    @Resource
    private RemoteConsumerExtraService remoteConsumerExtraService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public String sign(String plainText, PrivateKey rsaDuibaPrivateKey) throws Exception {
        Signature sign = Signature.getInstance(SHA256_WITH_RSA);
        sign.initSign(rsaDuibaPrivateKey);
        sign.update(plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])sign.sign());
    }

    public boolean verifySign(byte[] origin, PublicKey hsbcPublicKey, String param) throws Exception {
        Signature signature = Signature.getInstance(SHA256_WITH_RSA);
        signature.initVerify(hsbcPublicKey);
        signature.update(param.getBytes(StandardCharsets.UTF_8));
        return signature.verify(origin);
    }

    public String aesEncrypt(String plainText, byte[] key, byte[] vector) throws Exception {
        if (vector.length % 16 != 0) {
            throw new IllegalArgumentException(String.format("\u5411\u91cf\u957f\u5ea6\u5f02\u5e38 \u671f\u671b=%s \u5b9e\u9645=%s", 16, vector.length));
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(vector);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, ALGORITHM_AES);
        Cipher cipher = Cipher.getInstance(AES_PADDING_MODE);
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        byte[] bytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        return Base64Utils.encodeToString((byte[])bytes);
    }

    public String aesDecrypt(byte[] cipherText, byte[] key, byte[] vector) throws Exception {
        if (vector.length % 16 != 0) {
            throw new IllegalArgumentException(String.format("\u5411\u91cf\u957f\u5ea6\u5f02\u5e38 \u671f\u671b=%s \u5b9e\u9645=%s", 16, vector.length));
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(vector);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, ALGORITHM_AES);
        Cipher cipher = Cipher.getInstance(AES_PADDING_MODE);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] bytes = cipher.doFinal(cipherText);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public byte[] generateAesVector() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("NativePRNGNonBlocking");
        return sr.generateSeed(16);
    }

    public byte[] generateAesKey() throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_AES);
        kg.init(256);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    public byte[] rsaEncrypt(byte[] plainText, PublicKey hsbcPublicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_PADDING_MODE);
        cipher.init(1, hsbcPublicKey);
        byte[] bytes = plainText.length > 245 ? this.doSplit(plainText, cipher, 245) : cipher.doFinal(plainText);
        return bytes;
    }

    public byte[] rsaDecrypt(byte[] cipherText, PrivateKey rsaDuibaPrivateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_PADDING_MODE);
        cipher.init(2, rsaDuibaPrivateKey);
        byte[] bytes = cipherText.length > 256 ? this.doSplit(cipherText, cipher, 256) : cipher.doFinal(cipherText);
        return bytes;
    }

    private byte[] doSplit(byte[] cipherText, Cipher cipher, int threshold) throws Exception {
        int len = cipherText.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (len - offSet > 0) {
            byte[] cache = len - offSet > threshold ? cipher.doFinal(cipherText, offSet, threshold) : cipher.doFinal(cipherText, offSet, len - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * threshold;
        }
        out.close();
        return out.toByteArray();
    }

    public String getHostName(String url) {
        return url.substring(0, url.indexOf(63));
    }

    public String getParamUrl(String url) {
        return url.substring(url.indexOf(63) + 1);
    }

    public String generateToken(Map<String, Object> claims, Long appId) throws Exception {
        Date expireDate = new Date(System.currentTimeMillis() + 43200000L);
        HashMap headers = Maps.newHashMap();
        headers.put("kid", "FB9B22FCAC8C839F");
        headers.put("typ", "JWT");
        headers.put("ver", "1.0");
        headers.put("alg", "PS256");
        String hsbcJwtKeyConf = this.findHsbcJwtKeyConfByAppId(appId);
        String token = JWT_TOKEN_PREFIX + Jwts.builder().setHeaderParams((Map)headers).setClaims(claims).setExpiration(expireDate).setId("11111111").signWith((Key)SignUtil.readPrivateFromPEMFile(hsbcJwtKeyConf)).compact();
        return token;
    }

    public String sha256(String plainText) {
        Digester sha256 = new Digester(DigestAlgorithm.SHA256);
        return sha256.digestHex(plainText);
    }

    public PublicKey findHsbcPublicKeyByAppId(Long appId) {
        PublicKey publicKey = this.hsbcConfig.getAppId2HsbcPublicKeyMap().get(appId);
        if (Objects.isNull(publicKey)) {
            throw new IllegalArgumentException(String.format("\u6c47\u4e30\u516c\u94a5\u67e5\u8be2\u5931\u8d25\uff0cappId = %s", appId));
        }
        return publicKey;
    }

    public PrivateKey findDuibaPrivateKeyByAppId(Long appId) {
        PrivateKey privateKey = this.hsbcConfig.getAppId2RsaDuibaPrivateKeyMap().get(appId);
        if (Objects.isNull(privateKey)) {
            throw new IllegalArgumentException(String.format("\u5151\u5427\u67e5\u8be2\u5931\u8d25\uff0cappId = %s", appId));
        }
        return privateKey;
    }

    private String findHsbcJwtKeyConfByAppId(Long appId) {
        String jwtKeyConf = this.hsbcConfig.getAppId2JwtKeyConfMap().get(String.valueOf(appId));
        if (StringUtils.isBlank((String)jwtKeyConf)) {
            throw new IllegalArgumentException(String.format("\u6c47\u4e30jwt key\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cappId = %s", appId));
        }
        return jwtKeyConf;
    }

    public String findUserInfoUrlByAppId(Long appId) {
        String userInfoUrl = this.hsbcConfig.getAppId2UserInfoUrlMap().get(String.valueOf(appId));
        if (Objects.isNull(userInfoUrl)) {
            throw new IllegalArgumentException(String.format("\u6c47\u4e30userInfoUrl\u67e5\u8be2\u5931\u8d25\uff0cappId = %s", appId));
        }
        return userInfoUrl;
    }

    @Deprecated
    public String getUidByConsumerId(Long consumerId) {
        if (Objects.isNull(consumerId)) {
            throw new IllegalArgumentException("[hsbc]\u83b7\u53d6uid\u5931\u8d25 consumerId\u4e3a\u7a7a");
        }
        DubboResult dubboResult = this.remoteConsumerExtraService.findByConsumerId(consumerId);
        if (!dubboResult.isSuccess()) {
            throw new IllegalArgumentException(String.format("[hsbc]cid = %s \u83b7\u53d6uid\u5931\u8d25, remoteConsumerExtraService#findByConsumerId\u5f02\u5e38", consumerId));
        }
        ConsumerExtraDto consumerExtraDto = (ConsumerExtraDto)dubboResult.getResult();
        if (StringUtils.isBlank((String)consumerExtraDto.getJson())) {
            throw new IllegalArgumentException(String.format("[hsbc]cid = %s \u83b7\u53d6uid\u5931\u8d25\uff0c json\u5b57\u6bb5\u4e3a\u7a7a", consumerId));
        }
        JSONObject extJson = JSON.parseObject((String)consumerExtraDto.getJson());
        String uid = extJson.getString("uid");
        if (StringUtils.isBlank((String)uid)) {
            throw new IllegalArgumentException(String.format("[hsbc]cid = %s \u83b7\u53d6uid\u5931\u8d25\uff0cjson = %s", consumerId, consumerExtraDto.getJson()));
        }
        return uid;
    }
}

