/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.suning;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class RSAUtil {
    private static final String RSA = "RSA";
    private static final int RSA_SIZE_2048 = 2048;
    private static final int RSA_SIZE_1024 = 1024;
    private static final String MD5_WITH_RSA = "MD5withRSA";
    private static final String SHA1_WITH_RSA = "SHA1WithRSA";
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PUBLIC_KEY_B64 = "publicKeyBase64";
    public static final String PRIVATE_KEY = "privateKey";
    public static final String PRIVATE_KEY_B64 = "privateKeyBase64";

    public static boolean vertiy(byte[] data, byte[] sign, PublicKey pubk) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(SHA1_WITH_RSA);
        signature.initVerify(pubk);
        signature.update(data);
        return signature.verify(sign);
    }

    public static boolean vertiy(String data, String sign, PublicKey pubk) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        return RSAUtil.vertiy(data.getBytes(), Base64.decodeBase64((String)sign), pubk);
    }

    public static byte[] sign(byte[] data, PrivateKey prik) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(SHA1_WITH_RSA);
        signature.initSign(prik);
        signature.update(data);
        return signature.sign();
    }

    public static String sign(String data, PrivateKey prik) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        return Base64.encodeBase64String((byte[])RSAUtil.sign(data.getBytes(), prik)).trim();
    }

    public static PublicKey getPublicKey(String strPubKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)strPubKey));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        return pubKey;
    }

    public static PrivateKey getPrivateKey(String strPriKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec priKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)strPriKey));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PrivateKey priKey = keyFactory.generatePrivate(priKeySpec);
        return priKey;
    }

    public static String encrypt(Key key, String message) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, key);
        byte[] miwen = cipher.doFinal(message.getBytes());
        return String.valueOf(new BigInteger(miwen));
    }

    public static String decrypt(Key key, String message) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] miwen = new BigInteger(message).toByteArray();
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, key);
        byte[] result = cipher.doFinal(miwen);
        return new String(result);
    }
}

