package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.ZHCreditsConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Created by xutao on 2020/2/25.
 */
@Service
public class ZhbSyncApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZhbSyncApi.class);

    @Autowired
    private AppDAO appDAO;
    @Autowired
    private ZHCreditsConfig zhCreditsConfig;

    /**
     * 中宏保兑换记录请求url
     *
     * @return
     */
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        Map<String, String> authParams = msg.getHttpParams();
        authParams.put("appKey", app.getAppKey());
        authParams.put("appSecret", appDAO.getAppSecret(app));
        String sign = SignTool.sign(authParams);
        authParams.put("sign", sign);
        authParams.remove("appSecret");

        String url = zhCreditsConfig.getCrecordNotifyUrl();
        if(StringUtils.isBlank(url)){
            throw new ThirdpatyException("中宏保兑换记录同步url is not config");
        }
        HttpRequestBase http = AssembleTool.assemblePostRequest(url, JSONObject.toJSONString(authParams));
        HttpRequestLog.logUrl("[action crecord] [tag post request] [url " + url + "][param " + authParams + "]");
        return http;
    }

    /**
     * 判断是否是菜鸟裹裹appId
     *
     * @param appId
     * @return
     */
    public boolean isZHBApp(Long appId) {
        return zhCreditsConfig.isZHBApp(appId);
    }
}
