package cn.com.duiba.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

/**
 * @author JunAngLiu
 * @Title: ConfigBean
 * @Description:
 * @date 2018/10/1117:52
 */
@Configuration
@RefreshScope
public class HaidilaoConfigBean {

    //海底捞虚拟加积分链接
    @Value("${haidilao.virtual.addCredits.url}")
    private String virtualAddCreditsUrl;

    //海底捞虚拟发券链接
    @Value("${haidilao.virtual.url}")
    private String sendVirtualUrl;

    //火舞游戏链接
    @Value("${haidilao.huowu.game.url}")
    private String huowuGameUrl;

    @Value("${aliyun.app.appkey}")
    private String haidilaoAppKey;

    @Value("${aliyun.app.secret}")
    private String haidilaoAppSecret;

    //虚拟商品 以“LB-”开头 为加积分请求
    @Value("${haidilao.virtual.addCredits.pre}")
    private  String virtualAddPre;

    //火舞游戏虚拟商品的标识符格式
    @Value("${haidilao.huowu.game.pre}")
    private  String huowuGamePre;


    public String getVirtualAddCreditsUrl() {
        return virtualAddCreditsUrl;
    }

    public void setVirtualAddCreditsUrl(String virtualAddCreditsUrl) {
        this.virtualAddCreditsUrl = virtualAddCreditsUrl;
    }

    public String getSendVirtualUrl() {
        return sendVirtualUrl;
    }

    public void setSendVirtualUrl(String sendVirtualUrl) {
        this.sendVirtualUrl = sendVirtualUrl;
    }

    public String getHuowuGameUrl() {
        return huowuGameUrl;
    }

    public void setHuowuGameUrl(String huowuGameUrl) {
        this.huowuGameUrl = huowuGameUrl;
    }

    public String getHaidilaoAppKey() {
        return haidilaoAppKey;
    }

    public void setHaidilaoAppKey(String haidilaoAppKey) {
        this.haidilaoAppKey = haidilaoAppKey;
    }

    public String getHaidilaoAppSecret() {
        return haidilaoAppSecret;
    }

    public void setHaidilaoAppSecret(String haidilaoAppSecret) {
        this.haidilaoAppSecret = haidilaoAppSecret;
    }

    public String getVirtualAddPre() {
        return virtualAddPre;
    }

    public void setVirtualAddPre(String virtualAddPre) {
        this.virtualAddPre = virtualAddPre;
    }

    public String getHuowuGamePre() {
        return huowuGamePre;
    }

    public void setHuowuGamePre(String huowuGamePre) {
        this.huowuGamePre = huowuGamePre;
    }
}
