package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author XuJing
 * @since 2020/4/17 10:21 上午
 * 恰恰定制配置
 */
@Configuration
@ConfigurationProperties(prefix = "qiaqia")
public class QiaQiaConfig {
    private Set<Long> appIds = Sets.newHashSet(73247L);
    private String url = "https://openapi-peqiaqia-saasproj.shuyun.com/%s/%s%s";

    /**
     * 积分变更相关参数
     */
    private String pointContextPath = "openapi";
    private String pointVersion = "v2";
    private String pointRestPath = "/member/point";

    /**
     * 积分查询相关参数
     */
    private String selectContextPath = "openapi";
    private String selectVersion = "v2";
    private String selectRestPath = "/member/loyalty/info";


    private String serviceName = "qiaqia_duiba";
    private String serviceSecret = "qiaqiaksjwi1R8";
    private String memberType = "qiaqia";
    private String channelType = "DUIBA";

    private String virtualCreditsPre = "dbcredits_";

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPointContextPath() {
        return pointContextPath;
    }

    public void setPointContextPath(String pointContextPath) {
        this.pointContextPath = pointContextPath;
    }

    public String getPointVersion() {
        return pointVersion;
    }

    public void setPointVersion(String pointVersion) {
        this.pointVersion = pointVersion;
    }

    public String getPointRestPath() {
        return pointRestPath;
    }

    public void setPointRestPath(String pointRestPath) {
        this.pointRestPath = pointRestPath;
    }

    public String getSelectContextPath() {
        return selectContextPath;
    }

    public void setSelectContextPath(String selectContextPath) {
        this.selectContextPath = selectContextPath;
    }

    public String getSelectVersion() {
        return selectVersion;
    }

    public void setSelectVersion(String selectVersion) {
        this.selectVersion = selectVersion;
    }

    public String getSelectRestPath() {
        return selectRestPath;
    }

    public void setSelectRestPath(String selectRestPath) {
        this.selectRestPath = selectRestPath;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceSecret() {
        return serviceSecret;
    }

    public void setServiceSecret(String serviceSecret) {
        this.serviceSecret = serviceSecret;
    }

    public String getMemberType() {
        return memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getVirtualCreditsPre() {
        return virtualCreditsPre;
    }

    public void setVirtualCreditsPre(String virtualCreditsPre) {
        this.virtualCreditsPre = virtualCreditsPre;
    }
}
