package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * Created by 歪大哥😁 on 2019-10-25.
 */
@Configuration
@ConfigurationProperties(prefix = "zh.credits")
public class ZHCreditsConfig {

    // 兑吧在中宏的appKey
    private String appKey = "DUIBAMALL001";
    // 中宏积分商城appId
    private Set<Long> appIds = Sets.newHashSet(68071L);
    // AES加密秘钥
    private String secretKey = "uhbygv123456zxcv";
    // AES加密向量
    private String secretIv = "DUIBAMALL0123456";
    // 积分请求地址
    private String queryCreditsHost = "https://uat.manutouch.com.cn/mslintegral/v1/getUserIntegral";
    // 积分请求地址
    private String creditsHost = "https://uat.manutouch.com.cn/mslintegral/v1/changeUserIntegral";

    //中宏保appId
    private Set<Long> zhbAppIds = Sets.newHashSet(64150L);
    //中宏保兑换纪录同步url
    private String crecordNotifyUrl = "";

    // 中宏内部系统查询用户有效积分信息的transCode
    private String getCreditsTransCode = "DGUP02";
    // 中宏内部系统更新用户积分信息的transCode
    private String updateCreditsTransCode = "DGUP01";
    // 中宏公众号代码(对应domainCode)
    private String wpaId = "WPA02";
    // 新积分请求地址
    private String newQueryCreditsHost = "https://dgtapi.manulife-sinochem.com/dgtapishell/v1/gateway";
    // 兑吧在中宏的partnerCode
    private String partnerCode = "MCDDGDB";
    // salt(生产环境)
    private String salt = "pBQ1eTyk";

    public String getQueryCreditsHost() {
        return queryCreditsHost;
    }

    public void setQueryCreditsHost(String queryCreditsHost) {
        this.queryCreditsHost = queryCreditsHost;
    }

    public String getCreditsHost() {
        return creditsHost;
    }

    public void setCreditsHost(String creditsHost) {
        this.creditsHost = creditsHost;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSecretIv() {
        return secretIv;
    }

    public void setSecretIv(String secretIv) {
        this.secretIv = secretIv;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public Set<Long> getZhbAppIds() {
        return zhbAppIds;
    }

    public void setZhbAppIds(Set<Long> zhbAppIds) {
        this.zhbAppIds = zhbAppIds;
    }

    public String getCrecordNotifyUrl() {
        return crecordNotifyUrl;
    }

    public void setCrecordNotifyUrl(String crecordNotifyUrl) {
        this.crecordNotifyUrl = crecordNotifyUrl;
    }

    public boolean isZHApp(Long appId) {
        return CollectionUtils.isNotEmpty(appIds) && appIds.contains(appId);
    }

    public boolean isZHBApp(Long appId) {
        return CollectionUtils.isNotEmpty(zhbAppIds) && zhbAppIds.contains(appId);
    }

    public String getGetCreditsTransCode() {
        return getCreditsTransCode;
    }

    public void setGetCreditsTransCode(String getCreditsTransCode) {
        this.getCreditsTransCode = getCreditsTransCode;
    }

    public String getUpdateCreditsTransCode() {
        return updateCreditsTransCode;
    }

    public void setUpdateCreditsTransCode(String updateCreditsTransCode) {
        this.updateCreditsTransCode = updateCreditsTransCode;
    }

    public String getWpaId() {
        return wpaId;
    }

    public void setWpaId(String wpaId) {
        this.wpaId = wpaId;
    }

    public String getNewQueryCreditsHost() {
        return newQueryCreditsHost;
    }

    public void setNewQueryCreditsHost(String newQueryCreditsHost) {
        this.newQueryCreditsHost = newQueryCreditsHost;
    }

    public String getPartnerCode() {
        return partnerCode;
    }

    public void setPartnerCode(String partnerCode) {
        this.partnerCode = partnerCode;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }
}
