package cn.com.duiba.constant.shoppingTrolley;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/3/1 上午10:12
 */
@Configuration
@ConfigurationProperties("shopping.trolley")
public class ShoppingTrolleyConfig {

    private Set<Long> appIds = Sets.newHashSet(1L);

    public Boolean checkAppId(Long appId) {
        if (appIds.contains(appId)) {
            return true;
        }
        return false;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }
}
