package cn.com.duiba.notifycenter.service.impl;

import cn.com.duiba.constant.shoppingTrolley.ShoppingTrolleyConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.AppNewExtraDao;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.BussinessTypesService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.SlowRequestHandler;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.UrlUtils;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 通知业务数据封装
 */
@Service("bussinessTypesService")
public class BusinessTypeServiceImpl implements BussinessTypesService {

	private static Logger log = LoggerFactory.getLogger(BusinessTypeServiceImpl.class);

	@Autowired
	private AppDAO appDAO;
	@Autowired
	private CustomService customService;
	@Autowired
	private AppNewExtraDao appNewExtraDao;
	@Autowired
	private SlowRequestHandler slowRequestHandler;
	@Autowired
	private ShoppingTrolleyConfig shoppingTrolleyConfig;

	@Override
	public HttpUriRequest getRequest(NotifyQueueDO record) {
		try {
			DBTimeProfile.enter("getRequest");
			if(Objects.equals(record.getNotifyType(),NotifyTypeEnum.NOTIFY_PAY.getCode())){
				return getPayRequest(record);
			}
			if (Objects.equals(record.getNotifyType(), NotifyTypeEnum.NOTIFY_OBJECT_SEND.getCode())) {
				return getObjectSendRequest(record);
			}
			if (Objects.equals(record.getNotifyType(), NotifyTypeEnum.NOTIFY_POSTSALE.getCode())){
				return getPostsaleNotifyRequest(record);
			}
			if(NotifyQueueDto.RT_RE_SIGN_CARD.equals(record.getRelationType())){
				return getReSignRequest(record);
			}else{
				HttpUriRequest httpUriRequest = getCreditsRequest(record);
				if(httpUriRequest == null){
					return null;
				}

				String reqUrl = UrlUtils.buildUrl(httpUriRequest.getURI());
				if(slowRequestHandler.isBlackHost(reqUrl)){
					log.info("{} is black host*****", reqUrl);
					return null;
				}
				return httpUriRequest;
			}
		} finally {
			DBTimeProfile.release();
		}
	}

	private HttpUriRequest getPostsaleNotifyRequest(NotifyQueueDO record){
		AppDO app = appDAO.getAppByCache(record.getAppId());

		if(app == null){
			throw new IllegalStateException("app info为空");
		}
		String url = appNewExtraDao.findPostsaleNotify(record.getAppId());
		if (StringUtils.isBlank(url)){
			return null;
		}
		String paramStr = null;
		if (!StringUtils.isBlank(record.getError4developer())) {
			paramStr = record.getError4developer();
		}else {
			log.warn("完成售后通知接口参数为空，appId：{},通知记录Id:{}，订单号：{}"
					,record.getAppId(),record.getId(),record.getDuibaOrderNum());
			return null;
		}

		// 定制接口的APIURL 目前还没有定制
//		HttpRequestBase customRequest = null;
//		if(customRequest != null){
//			customRequest.setConfig(getDefaultConfig());
//			return customRequest;
//		}
		Map<String, String> map=buildPostsaleNotifyMap(record,paramStr,app);
		HttpRequestBase request = new HttpGet(AssembleTool.assembleUrl(url, map));
		request.setConfig(getDefaultConfig());
		return request;

	}

	/**
	 * 构建请求参数
	 * **/
	private Map<String, String> buildPostsaleNotifyMap(NotifyQueueDO record,String paramStr,AppDO app){
		JSONObject jsonObject= JSON.parseObject(paramStr);
		Map<String, String> map =new HashMap<>();
		map.put("appKey",app.getAppKey());
		map.put("uid",getString(record.getPartnerUserId()));
		map.put("timestamp",System.currentTimeMillis() + "");
		map.put("orderNum",getString(record.getDuibaOrderNum()));
		if (StringUtils.isNotBlank(getString(record.getDeveloperBizId()))){
			map.put("bizId",getString(record.getDeveloperBizId()));
		}
		map.put("totalAmount",jsonObject.getString("totalAmount"));
		map.put("freightAmount",jsonObject.getString("freightAmount"));
		map.put("totalCredits",jsonObject.getString("totalCredits"));
		map.put("realPayAmount",jsonObject.getString("realPayAmount"));
		map.put("realPayCredits",jsonObject.getString("realPayCredits"));
		map.put("refundAmount",jsonObject.getString("refundAmount"));
		map.put("appSecret",appDAO.getAppSecret(app));
		if (StringUtils.isNotBlank(record.getTransfer())){
			map.put("transfer",record.getTransfer());
		}
		String sign = SignTool.sign(map);
		map.remove("appSecret");
		map.put("sign",sign);
		return map;
	}

	private String getString(Object o) {
		return o == null ? "" : o.toString();
	}

	private HttpUriRequest getCreditsRequest(NotifyQueueDO record){
		AppDO app = appDAO.getAppByCache(record.getAppId());

		if(app == null){
			throw new IllegalStateException("app info为空");
		}

		if (app.getCreditsConsumeNotifyUrl() == null || app.getCreditsConsumeNotifyUrl().length() == 0) {
			return null;
		}

		String errorMessage = "";
		if (record.getError4developer() != null) {
			errorMessage = record.getError4developer();
		}
		String uid = record.getPartnerUserId();
		if (uid == null) {
			uid = "";
		}
		String bizId = "";
		if (record.getDeveloperBizId() != null) {
			bizId = record.getDeveloperBizId();
		}

		CreditNotifyParams p = new CreditNotifyParams();
		p.setSuccess(record.getResult());
		p.setErrorMessage(errorMessage);
		p.setAppKey(app.getAppKey());
		p.setBizId(bizId);
		p.setUid(uid);
		p.setOrderNum(record.getDuibaOrderNum());
		String time="";
		if(customService.isMobike(app.getId())){
			time=String.valueOf(new Date().getTime()/1000L);
		}

		// 定制接口的APIURL/ 等于空就没有定制
		HttpRequestBase customRequest = customService.getRequestNotify(app.getCreditsConsumeNotifyUrl(), record,time, app, p);
		if(customRequest != null){
			customRequest.setConfig(getDefaultConfig());
			return customRequest;
		}
		// todo 通知回滚积分
		Map<String, String> map;
		String transfer = record.getTransfer();
		if(StringUtils.isNotBlank(transfer)){
			map = customService.toRequestMapWithTransfer(appDAO.getAppSecret(app),p,transfer,uid);
		} else {
			map = p.toRequestMap(appDAO.getAppSecret(app));
		}
		// 定制-购物车取消发货失败订单
		if (shoppingTrolleyConfig.checkAppId(record.getAppId()) && record.getRollbackCredits() != null) {
			map.put("rollbackCredits", String.valueOf(record.getRollbackCredits()));
		}

		HttpRequestBase request;
		if (customService.isPostApp(app.getId())) {
			request = assembleRequest(app.getCreditsConsumeNotifyUrl(), map);
		}else if(customService.isPayqb(app.getId())){
			request = assemblePostRequestForJson(app.getCreditsConsumeNotifyUrl(), map);
		} else {
			request = new HttpGet(AssembleTool.assembleUrl(app.getCreditsConsumeNotifyUrl(), map));
		}
		request.setConfig(getDefaultConfig());
		return request;
	}

	private HttpRequestBase assemblePostRequestForJson(String url, Map<String, String> params) {
		HttpPost post = new HttpPost(url);
		try{
			net.sf.json.JSONObject jsonObject = net.sf.json.JSONObject.fromObject(params);
			String json = jsonObject.toString();
			StringEntity postingString = new StringEntity(json,Charset.forName("utf-8"));// json传递
			post.setHeader("Content-Type", "application/json");
			post.setEntity(postingString);
		}catch (Exception e){
			log.error("BusinessTypeServiceImpl call assembleRequestForRaw error,url = {},params = {}",
					url,JSONObject.toJSONString(params),e);
		}
		return post;

	}

	private HttpUriRequest getReSignRequest(NotifyQueueDO record) {
		DBTimeProfile.enter("getReSignRequest");

		AppDO app = appDAO.getAppByCache(record.getAppId());
		String url = appNewExtraDao.findVirtualCardConsumeNotify(record.getAppId());
		if(StringUtils.isBlank(url)){
			return null;
		}
		String errorMessage = record.getError4developer();
		String uid = record.getPartnerUserId();
		String bizId = record.getDeveloperBizId();

		/**
		 * 签名与扣积分相同
		 */
		CreditNotifyParams p = new CreditNotifyParams();
		p.setSuccess(record.getResult());
		p.setErrorMessage(errorMessage == null ? "" : errorMessage);
		p.setAppKey(app.getAppKey());
		p.setBizId(bizId == null ? "" : bizId);
		p.setUid(uid == null ? "" : uid);
		p.setOrderNum(record.getDuibaOrderNum());

		Map<String, String> map = p.toRequestMap(appDAO.getAppSecret(app));

		HttpRequestBase request = new HttpGet(AssembleTool.assembleUrl(url, map));
		request.setConfig(getDefaultConfig());
		return request;
	}

	private HttpUriRequest getPayRequest(NotifyQueueDO record){
		AppDO app = appDAO.getAppByCache(record.getAppId());

		//暂时是阿里体育的定制需求，后续推广为全平台功能是从app信息中取url
		if(!customService.isAlisports(app.getId())){
			return null;
		}
		String notifyUrl = "http://sportsbank.taobao.com/credit/rmbPayment";
		String errorMessage = "";
		if (record.getError4developer() != null) {
			errorMessage = record.getError4developer();
		}
		String uid = record.getPartnerUserId();
		if (uid == null) {
			uid = "";
		}
		String bizId = "";
		if (record.getDeveloperBizId() != null) {
			bizId = record.getDeveloperBizId();
		}

		CreditNotifyParams p = new CreditNotifyParams();
		p.setSuccess(record.getResult());
		p.setErrorMessage(errorMessage);
		p.setAppKey(app.getAppKey());
		p.setBizId(bizId);
		p.setUid(uid);
		p.setOrderNum(record.getDuibaOrderNum());

		Map<String, String> map= p.toRequestMap(appDAO.getAppSecret(app));

		HttpRequestBase request;
		final String url = AssembleTool.assembleUrl(notifyUrl, map);
		request = new HttpGet(url);
		request.setConfig(getDefaultConfig());
		return request;
	}

	/**
	 * 封装实物发货通知请求
	 * @param record
	 * @return
	 */
	private HttpUriRequest getObjectSendRequest(NotifyQueueDO record) {

		//获取实物发货通知接口
		String url = appNewExtraDao.findDeliverObjectOrderNotify(record.getAppId());
		if(StringUtils.isBlank(url)){
			//未填写地址，返回
			return null;
		}
		AppDO app = appDAO.getAppByCache(record.getAppId());
		String errorMessage = record.getError4developer();
		String uid = record.getPartnerUserId();
		String bizId = record.getDeveloperBizId();

		CreditNotifyParams p = new CreditNotifyParams();
		p.setSuccess(record.getResult());
		p.setErrorMessage(errorMessage == null ? "" : errorMessage);
		p.setAppKey(app.getAppKey());
		p.setBizId(bizId == null ? "" : bizId);
		p.setUid(uid == null ? "" : uid);
		p.setOrderNum(record.getDuibaOrderNum());

		Map<String, String> map = p.toRequestMap(appDAO.getAppSecret(app));

		String transfer = record.getTransfer();
		JSONObject jsonObject = JSONObject.parseObject(transfer);
		String goodsId = jsonObject.getString("gid");
		String goodsName = jsonObject.getString("gName");
		String expressId = jsonObject.getString("eid");
		String expressName = jsonObject.getString("eName");

		if (StringUtils.isNotBlank(goodsId)) {
			map.put("goodsId", goodsId);
		}
		if (StringUtils.isNotBlank(goodsName)) {
			map.put("goodsName", goodsName);
		}
		map.put("expressId", expressId == null ? "" : expressId);
		map.put("expressName", expressName == null ? "" : expressName);
		HttpRequestBase request = new HttpGet(AssembleTool.assembleUrl(url, map));
		request.setConfig(getDefaultConfig());
		return request;
	}



	/**
	 * 通知超时时间
	 * 
	 * @return
	 */
	private RequestConfig getDefaultConfig() {
		return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
	}

	/**
	 * 参数拼接URL
	 * 
	 * @param url
	 * @param params
	 * @return
	 */
	public HttpPost assembleRequest(String url, Map<String, String> params) {
		List<NameValuePair> pairs = new ArrayList<>(params.size());
		for (Map.Entry<String, String> entry : params.entrySet()) {
			String value = entry.getValue();
			if (value != null) {
				pairs.add(new BasicNameValuePair(entry.getKey(), value));
			}
		}
		HttpPost post = new HttpPost(url);
		post.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName("utf-8")));
		return post;
	}
}
