package cn.com.duiba.remoteimpl.yumin;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.yumin.YmBankConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.thirdparty.api.yumin.RemoteYmBankService;
import cn.com.duiba.thirdparty.dto.yumin.CheckBuyPermRequestDto;
import cn.com.duiba.thirdparty.dto.yumin.CheckBuyPermResponseDto;
import cn.com.duiba.thirdparty.dto.yumin.GoodsParamDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author chenzhenxing
 * @date 2021/11/16 11:35 上午
 */
@RestController
public class RemoteYmBankServiceImpl implements RemoteYmBankService {

    private static final Logger log = LoggerFactory.getLogger(RemoteYmBankServiceImpl.class);

    private static final RequestConfig requestConfig;
    private static final int FIVE_SECONDS = 5*1000;
    private static final int TEN_SECONDS = 10*1000;

    private static final String CHECK_BUY_PERMISSION_PATH = "duiba/integral_mall/buyPermissions";

    static {
        //http请求超时配置
        requestConfig = RequestConfig.custom().setConnectTimeout(FIVE_SECONDS).setSocketTimeout(TEN_SECONDS).setConnectionRequestTimeout(500).build();
    }

    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    @Resource
    private YmBankConfig ymBankConfig;

    @Override
    public CheckBuyPermResponseDto checkBuyPerm(CheckBuyPermRequestDto requestDto) throws BizException {
        Map<String, String> param = Maps.newHashMap();
        param.put("appKey",requestDto.getAppKey());
        param.put("appSecret",requestDto.getAppSecret());
        param.put("timestamp", String.valueOf(System.currentTimeMillis()));
        param.put("uid",requestDto.getUid());
        param.put("goodsId",requestDto.getGoodsId());
        GoodsParamDto dto = requestDto.getGoodsParam();
        if (null != dto && null != dto.getAppItemId()){
            //字段为null给默认值
            GoodsParamDto goodsParamDto = new GoodsParamDto();
            goodsParamDto.setAppItemId(dto.getAppItemId());
            if (dto.getSmall_image() != null){
                goodsParamDto.setSmall_image(dto.getSmall_image());
            }else {
                goodsParamDto.setSmall_image("");
            }
            if (dto.getLogo() != null){
                goodsParamDto.setLogo(dto.getLogo());
            }else {
                goodsParamDto.setLogo("");
            }
            if (dto.getBanner_image() != null){
                goodsParamDto.setBanner_image(dto.getBanner_image());
            }else {
                goodsParamDto.setBanner_image("");
            }
            if (dto.getTitle() != null){
                goodsParamDto.setTitle(dto.getTitle());
            }else {
                goodsParamDto.setTitle("");
            }
            if (dto.getUrl() != null){
                goodsParamDto.setUrl(dto.getUrl());
            }else {
                goodsParamDto.setUrl("");
            }
            if (StringUtils.isEmpty(dto.getFacePrice()) || "null".equals(dto.getFacePrice())){
                goodsParamDto.setFacePrice("");
            }else {
                goodsParamDto.setFacePrice(dto.getFacePrice());
            }

            if (StringUtils.isEmpty(dto.getCash()) || "null".equals(dto.getCash())){
                goodsParamDto.setCash("");
            }else {
                goodsParamDto.setCash(dto.getCash());
            }

            if (StringUtils.isEmpty(dto.getCredits()) || "null".equals(dto.getCredits())){
                goodsParamDto.setCredits("0");
            }else {
                goodsParamDto.setCredits(dto.getCredits());
            }

            if (StringUtils.isEmpty(dto.getRemainStock()) || "null".equals(dto.getRemainStock())){
                goodsParamDto.setRemainStock("");
            }else {
                goodsParamDto.setRemainStock(dto.getRemainStock());
            }
            param.put("goodsParam",JSON.toJSONString(goodsParamDto));
        }
        param.put("sign", SignTool.sign(param));
//        传给开发者参数去掉appSecret
        param.remove("appSecret");
        String url = ymBankConfig.getUrl() + CHECK_BUY_PERMISSION_PATH;
        String assembleUrl = AssembleTool.assembleUrl(url, param);
        log.info("裕民银行-请求url，url:{}", assembleUrl);
        HttpGet httpGet = new HttpGet(assembleUrl);
        httpGet.setConfig(requestConfig);
        String s = ymBankRequest(httpGet);
        CheckBuyPermResponseDto checkBuyPermResponseDto = JSONObject.parseObject(s, CheckBuyPermResponseDto.class);
        if (checkBuyPermResponseDto == null || "fail".equals(checkBuyPermResponseDto.getStatus())) {
            throw new BizException("系统繁忙，请稍后重试");
        }
        return checkBuyPermResponseDto;
    }

    private String ymBankRequest(HttpUriRequest httpRequest) {
        try(final CloseableHttpResponse response = httpClient.execute(httpRequest)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("裕民银行响应参数，param:{}", responseStr);
            return responseStr;
        } catch (Exception e) {
            log.warn("裕民银行响应异常，url:{},param:{}",httpRequest.getURI().getPath(), JSON.toJSONString(httpRequest), e);
        }
        return null;
    }
}
