package cn.com.duiba.tool.sn;

import org.springframework.util.Assert;

import java.security.PublicKey;

public class SignatureVerifier {

    /**
     * 验证16进制签名
     * @param plain 交易数据明文
     * @param signature 签名
     * @param algorithm 签名算法
     * @param publicKey java.security.PublicKey 公钥
     * @return 验证是否成功
     */
    public boolean verify(String plain, String signature, String algorithm, PublicKey publicKey) {
        Assert.notNull(plain, " plain is null.");
        Assert.notNull(signature, "signature is null.");
        Assert.notNull(algorithm, "algorithm is null.");
        Assert.notNull(publicKey, "public key is null.");
        try {
            java.security.Signature sign = java.security.Signature.getInstance(algorithm);
            sign.initVerify(publicKey);
            sign.update(plain.getBytes());
            byte[] signatureByteArray = Hex.toByte(signature); //转换为字节数组
            return sign.verify(signatureByteArray);
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}
