package cn.com.duiba.order.center.api.constant;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

public enum VisitChannelEnum {
    APP(1, "app"),
    WX_LITE(2, "微信小程序"),
    ALIPAY(3, "支付宝"),
    ;

    private int code;
    private String desc;

    VisitChannelEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final ImmutableMap<Integer, VisitChannelEnum> ALL_MAP;
    static {
        Map<Integer, VisitChannelEnum> tmpMap = Maps.newHashMap();
        for(VisitChannelEnum tmpEnum : VisitChannelEnum.values()) {
            tmpMap.put(tmpEnum.getCode(), tmpEnum);
        }
        ALL_MAP = ImmutableMap.copyOf(tmpMap);
    }

    public static VisitChannelEnum getByCode(Integer code) {
        return ALL_MAP.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
