package cn.com.duiba.order.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrderAssetDeductDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @ClassName: RemoteAmbOrderFastService
 * @Description: 订单支付资产抵扣记录接口
 * @author: fxr
 * @date: 2018/9/14 下午4:40
 * @version: V1.0.0
 */
@AdvancedFeignClient
public interface RemoteOrderAssetDeductService {

    OrderAssetDeductDto createDeductRecord(OrderAssetDeductDto orderAssetDeductDto);
    /**
     * 根据订单号获取抵扣记录
     * @param orderId
     * @return
     */
    OrderAssetDeductDto getDeductRecordByOrderId(Long orderId);
    /**
     * 根据订单号,批量获取抵扣记录
     * @param orderIds
     * @return
     */
    List<OrderAssetDeductDto> findDeductRecordByOrderIds(List<Long> orderIds);

    /**
     * 根据订单号更新抵扣记录状态
     * @param orderId
     * @param deductStatus
     * @return
     */
    Integer updateDeductRecordStatusByOrderId(Long orderId, Integer deductStatus);

}
