package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * @author qianjue
 * @date 2018/12/11
 * @description: 订单主类型枚举
 */
public enum ExtraInfoToEsRelationEnum {
    //通用
    SUPPLIER(EsCustomFieldEnum.SUPPLIERIDS),

    //万达定制-员工
    STAFFTAG(EsCustomFieldEnum.CUSTOM_STRING_ONE),

    //万达定制-分销
    DISTRIBUTION(EsCustomFieldEnum.CUSTOM_STRING_TWO),
    ;



    private EsCustomFieldEnum customEsFieldName;



    private ExtraInfoToEsRelationEnum( EsCustomFieldEnum field){
        this.customEsFieldName = field;
    }
    public EsCustomFieldEnum getCustomEsFieldName() {
        return customEsFieldName;
    }

    public static ExtraInfoToEsRelationEnum ofValue(String extraFieldName){
        for (ExtraInfoToEsRelationEnum orderEnum:values()){
            if (Objects.equals(orderEnum.getCustomEsFieldName(),extraFieldName)){
                return orderEnum;
            }
        }
       return null;
    }
}
