package cn.com.duiba.order.center.api.paramquery;

import cn.com.duiba.order.center.api.paramquery.common.PageParam;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 订单售后问题查询条件
 *
 * @author ykb
 * @date 2023-02-15
 */
@Getter
@Setter
@NoArgsConstructor
public class OrderAfterSaleSearchParam extends PageParam {

    /**
     * 时间创建
     */
    private Date gmtStart;

    /**
     * 时间修改
     */
    private Date gmtEnd;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 用户partnerUserId
     */
    private String partnerUserId;

    /**
     * 类型@see
     */
    private Integer type;

    @Builder
    public OrderAfterSaleSearchParam(Integer pageNum, Integer pageSize, String orderBy, String desc, Date gmtStart, Date gmtEnd, Long appId, String orderNum, String partnerUserId, Integer type) {
        super(pageNum, pageSize, orderBy, desc);
        this.gmtStart = gmtStart;
        this.gmtEnd = gmtEnd;
        this.appId = appId;
        this.orderNum = orderNum;
        this.partnerUserId = partnerUserId;
        this.type = type;
    }
}
