package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AlipayBatchLogDto;
import cn.com.duiba.order.center.api.paramquery.AabnormalOrderQueryParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by yansen on 16/10/26.
 * 支付宝批量付款记录
 */
@AdvancedFeignClient
public interface RemoteAlipayBatchLogService {
    /**
     *
     * @param alipayBatchLogDto
     * @return
     */
    public DubboResult<AlipayBatchLogDto> insert(AlipayBatchLogDto alipayBatchLogDto);

    /**
     *
     * @param alipayBatchLogDto
     * @return
     */
    public DubboResult<AlipayBatchLogDto> update(AlipayBatchLogDto alipayBatchLogDto);

    /**
     *
     * @param batchNo
     * @return
     */
    public DubboResult<AlipayBatchLogDto> findByBatchNo(String batchNo);

    public List<AlipayBatchLogDto> findAbnormalBatchByTime(AabnormalOrderQueryParams queryParam);

    Long findAbnormalBatchByTimeCount(AabnormalOrderQueryParams queryParam);
}
