package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.paramquery.AccountLimitQueryParam;
import cn.com.duiba.order.center.api.paramquery.ConsumerAccountLimitRecordParam;

/**
 * @Author: fss
 * @Date: 2022/9/20 10
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteConsumerAccountLimitRecordService {

    /**
     * 查询用户限制条件下已购条数
     *
     * @param accountLimitQueryParam
     * @return
     */
    public Integer countByItemKeyAccountAndDate(AccountLimitQueryParam accountLimitQueryParam);

    /**
     * 永久限购条数
     *
     * @param accountLimitQueryParam
     * @return
     */
    public Integer countByItemKeyAccount(AccountLimitQueryParam accountLimitQueryParam);

    /**
     * 用于订单失败、限购数据删除
     * @param sourceId 业务ID
     * @param sourceType 业务类型
     */
    Integer deleteBySource(Long sourceId, String sourceType);

    /**
     * 账户插入限购限制
     * @param consumerAccountLimitRecordParam
     * @return
     */
    Integer lockCheckAndInsert(ConsumerAccountLimitRecordParam consumerAccountLimitRecordParam) throws BizException;

}
