package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAmbOrderScanService <br/>
 * 定时扫描加速表订单并处理业务逻辑 <br/>
 * Date: 2017年2月6日 上午10:09:10 <br/>
 * 
 * @author sunyan
 */
@AdvancedFeignClient
public interface RemoteAmbOrderScanService {

    /**
     * 支付超时处理
     *
     * @param fastId
     * @return DubboResult
     */
    DubboResult<OrdersDto> payTimeout(Long fastId);

    /**
     * 等待收货超时
     *
     * @param fastId
     * @return DubboResult
     */
    DubboResult<OrdersDto> waitReceiveTimeout(Long fastId);

    /**
     * 收货7天后，不走售后 订单结束
     *
     * @param fastId
     * @return DubboResult
     */
    DubboResult<OrdersDto> receivedTimeout(Long fastId);

    /**
     * 用户审请售后之后，7天后，没人处理。自动同意
     *
     * @param fastId
     * @return DubboResult
     */
    DubboResult<OrdersDto> postsaleApplyTimeout(Long fastId);

    /**
     * 同意申请售后，7天后，用户未上传物流和单号，自动拒绝
     *
     * @param fastId
     * @return DubboResult
     */
    DubboResult<OrdersDto> postsaleUserSendTimeout(Long fastId);

    /**
     * 上传物流后，7天未完成售后，自动同意
     * 
     * @param fastId
     * @return DubboResult
     */
    void postsaleMerchantsReceiveTimeout(Long fastId);

    /**
     * 商家同意售后无需退货，7天未完成售后，强制完成
     *
     * @param fastId
     * @return DubboResult
     */
    void postsaleAgreeNoGoodsTimeout(Long fastId);
    /**
     * 购物车售后订单，更新金额
     * @param fastId
     * @return
     */
    DubboResult<OrdersDto> postsaleShoppingCartComplete(Long fastId);
    
    /**
     * 60天超时定单处理
     * 
     * @param fastId
     * @return DubboResult
     */
    DubboResult<OrdersDto> maxTimeTimeout(Long fastId);

    @Deprecated
    DubboResult<OrdersDto> postsaleRejectTimeout(Long fastId);

    @Deprecated
    DubboResult<OrdersDto> postsaleAgreeTimeout(Long fastId);
}
