package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.SkinTemplateDTO;
import cn.com.duiba.tuia.activity.center.api.dto.req.SkinQueryReq;

/**
 * 描述: 皮肤弹层模板远程服务
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2019/11/26 11:03
 */
@AdvancedFeignClient
public interface RemoteSkinTemplateService {

    /**
     * 分页查询弹层皮肤
     *
     * @param req
     * @return PageDto
     */
    PageDto<SkinTemplateDTO> selectLayerSkinPage(SkinQueryReq req);

    /**
     * 查询弹层皮肤
     *
     * @param id
     * @return
     */
    SkinTemplateDTO selectLayerSkin(Long id);

    /**
     * 保存弹层皮肤
     *
     * @param dto dto
     * @return ids
     */
    Long saveLayerSkin(SkinTemplateDTO dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    int deleteById(Long id);

}
