package cn.com.duiba.tuia.activity.center.api.log;

import lombok.Data;

import java.io.Serializable;

/**
 * 统一维护
 * 全链路日志 字段对象
 * @author miaohongshuai
*/
@Data
public class FullLinkLog implements Serializable {

    private static final long serialVersionUID = -5484786522241537889L;

    /**
     * 数据接入方式标识
     * slotInterBigType：新版SDK=1，新版API、素材API、广告位链接、展示API、互动直投API	=2，ADX=3，讯飞类-广告位链接拼接设备号=4
     * slotInterSmallType：新版SDK=1、新版API=1，素材API=2、广告位链接=3、展示API=4、互动直投API=5，ADX=1，讯飞类-广告位链接拼接设备号=1
     * Fk：广告位投放链接，媒体只回传device_id=1，通过设备号更新deviceId=2，推啊生成deviceId=3
     * actMainTitleId：活动主标题ID
     * actSubTitleId： 活动副标题ID
     * actPageMainTitleId：自定义活动主标题ID
     * actPageSubTitleId：自定义活动副标题ID
     * actTitleActualPutType：活动标题实际投放类型 0-人工图片标题 1-人工配置标题 2-算法推荐标题
     * slotTitleTheoryPutType：活动标题理论投放类型 1-人工标题 2-算法标题
     * slotInterBigType：新版SDK、老版SDK=1，新版API、广告位链接、展示API、互动直投API =2，ADX=3，讯飞类-广告位链接拼接设备号、原生类--广告位链接拼接设备号=4
     * slotInterSmallType：新版SDK、新版API、ADX、讯飞类-广告位链接拼接设备号=1，老版SDK、原生类--广告位链接拼接设备号=2、广告位链接=3、展示API=4、互动直投API=5
     * Fk：广告位投放链接，媒体只回传device_id=1，通过设备号更新deviceId=2，推啊生成deviceId=3
     * 需求文档：http://cf.dui88.com/pages/viewpage.action?pageId=43759568
     */
    private String slotInterBigType;
    private String slotInterSmallType;
    private String Fk;

    private String actMainTitleId;
    private String actSubTitleId;
    private String actPageMainTitleId;
    private String actPageSubTitleId;
    private String actTitleActualPutType;
    private String slotTitleTheoryPutType;

}
