/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public enum ApusSpecEnum {
    A_PUS_001("001", "APUS-\u4fe1\u606f\u6d41", 34, "1-2", "\u5927\u56fe", Lists.newArrayList((Object[])new Integer[]{600}), Lists.newArrayList((Object[])new Integer[]{400}), 1, 150, "jpg/png/jpeg/gif", 30, 30),
    A_PUS_002("002", "APUS-\u5f00\u5c4f", 35, "", "\u5927\u56fe", Lists.newArrayList((Object[])new Integer[]{1080}), Lists.newArrayList((Object[])new Integer[]{1920}), 1, 150, "jpg/png/jpeg", null, null),
    A_PUS_003("003", "APUS-\u63d2\u5c4f", 36, "1-2", "\u5927\u56fe", Lists.newArrayList((Object[])new Integer[]{600}), Lists.newArrayList((Object[])new Integer[]{400}), 1, 150, "jpg/png/jpeg/gif", 30, 30),
    A_PUS_004("004", "APUS-\u539f\u751f-\u56fe\u6587\u6458\u8981", 37, "1-2", "\u5927\u56fe+icon", Lists.newArrayList((Object[])new Integer[]{600}), Lists.newArrayList((Object[])new Integer[]{400}), 1, 150, "jpg/png/jpeg/gif", 30, 30),
    A_PUS_005("005", "APUS-\u539f\u751f-\u5927\u56fe", 38, "", "\u5927\u56fe", Lists.newArrayList((Object[])new Integer[]{1080}), Lists.newArrayList((Object[])new Integer[]{1920}), 1, 150, "jpg/png/jpeg/gif", null, null);

    private String specCode;
    private String name;
    private Integer styleStandard;
    private String template;
    private String templateDescription;
    private List<Integer> picW;
    private List<Integer> picH;
    private Integer picNum;
    private Integer size;
    private String picType;
    private Integer titleLimit;
    private Integer contentLimit;

    private ApusSpecEnum(String specCode, String name, Integer styleStandard, String template, String templateDescription, List<Integer> picW, List<Integer> picH, Integer picNum, Integer size, String picType, Integer titleLimit, Integer contentLimit) {
        this.specCode = specCode;
        this.name = name;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.picW = picW;
        this.picH = picH;
        this.picNum = picNum;
        this.size = size;
        this.picType = picType;
        this.titleLimit = titleLimit;
        this.contentLimit = contentLimit;
    }

    public String getName() {
        return this.name;
    }

    public Integer getStyleStandard() {
        return this.styleStandard;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public String getSpecCode() {
        return this.specCode;
    }

    public List<Integer> getPicW() {
        return this.picW;
    }

    public List<Integer> getPicH() {
        return this.picH;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getPicType() {
        return this.picType;
    }

    public Integer getTitleLimit() {
        return this.titleLimit;
    }

    public Integer getPicNum() {
        return this.picNum;
    }

    public Integer getContentLimit() {
        return this.contentLimit;
    }

    public static ApusSpecEnum getEnumByStyleStandard(Integer styleStandard) {
        if (Objects.isNull(styleStandard)) {
            return null;
        }
        return Stream.of(ApusSpecEnum.values()).filter(e -> e.getStyleStandard().equals(styleStandard)).findFirst().orElse(null);
    }

    public static boolean isInfoFlow(ResourceIdeaDto ideaDto) {
        if (ideaDto == null || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }
        ApusSpecEnum specEnum = ApusSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull((Object)specEnum) && (specEnum == A_PUS_001 || specEnum == A_PUS_003 || specEnum == A_PUS_004);
    }

    public static boolean isSummary(ResourceIdeaDto ideaDto) {
        if (Objects.isNull(ideaDto) || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }
        ApusSpecEnum specEnum = ApusSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull((Object)specEnum) && (specEnum == A_PUS_001 || specEnum == A_PUS_003 || specEnum == A_PUS_004);
    }
}

