package cn.com.duiba.tuia.activity.center.api.constant.adx;

import org.apache.commons.lang.StringUtils;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * adx平台类型
 *
 * @author weny.cai
 * @date 2019/1/3 15:46
 **/
public enum AdxTypeEnum {

    /** 猎豹 ADX */
    LIEBAO(1, "猎豹", false, 1,"55287","3", false, false),

    /** 搜狗 ADX */
    SOUGOU(2, "搜狗", false, 1,"56100","10", false, false),

    /** 墨迹天气 ADX */
    MOJI(3, "墨迹天气", false, 1,"57045","11", false, false),

    /** 暴风影音 ADX */
    BAOFENG(4, "暴风影音", false, 2,"58196","18", false, false),

    /** 百度视频 ADX */
    BAIDU(5, "百度视频", true, 3,"58834","17", false, false),

    /** 小米 ADX */
    XIAOMI(6, "小米", false, 2,"58972","21", false, false),

    /** 掌阅 ADX */
    ZHANG_YUE(7, "掌阅", true, 2,"61112","31", false, false),

    /** 2345 ADX */
    NAVIGATION(8, "2345", true, 3,"63596","42", false, false),

    /** 连尚 ADX */
    LIAN_SHANG(9, "连尚", false, 2,"64738","59", false, false),

    /** 小恩爱 ADX */
    XIAO_EN_AI(10, "小恩爱", true, 2,"63597","71", false, false),

    /** OPPO ADX */
    OPPO(11, "OPPO", true, 2,"66506","84", false, false),

    /** 爱奇艺 ADX */
    I_QI_YI(12, "爱奇艺", true, 2,"69636","96", true, true),

    /** MEIZU ADX */
    MEIZU(13, "魅族", true, 2,"68016","94", false, false),

    /** 芒果TV ADX */
    MONGO_TV(14, "芒果TV", true, 3,"69972","124", true, false),

    /** apus ADX */
    APUS(15, "APUS", true, 2, "69989","115", false, false),

    /** 美数 ADX */
    MEI_SHU(16, "美数", true, 2, "69822","118", false, false),

    /** Lenovo ( 联想 ) ADX */
    LENOVO(17, "联想", true, 3, "70379","125", true, false),

    /** 陌陌 ADX **/
    MOMO(18, "陌陌", true, 3, "70391","119", true, false),

    /** Baidu Alliance ( 百度联盟 ) ADX */
    BAIDU_ALLIANCE(19, "百度联盟", false, 3, "71092","129", true, false),

    /** 中文万维 **/
    IWANVI(20, "中文万维", false, 3, "71189","130", true, false),

    /** 陌陌开屏 ADX **/
    MOMO_OPEN_SCREEN(21, "陌陌开屏", false, 3, "71941","134", true, false),

    /** 蜻蜓 ADX **/
    QINGTING(22, "蜻蜓", false, 3, "73007","136", true, false),

    /** 京东金融 ADX **/
    JD_FINANCE(23, "京东金融", true, 3, "54751","135", true, false);


    private Integer type;

    private String name;

    /** 是否需要审核 */
    private Boolean needAudit;
    /**
     * 广告类型存储方式 1-posId 2-spec_code 3-其他
     */
    private Integer storeType;

    /** 是否走新的ADX架构标识符 **/
    private boolean isUpgrade;

    /**媒体ID**/
    private String mediaId;

    /**推广组ID**/
    private String groupId;

    /**广告主是否需要送审**/
    private Boolean advertiserNeedAudit;

    AdxTypeEnum(Integer type, String name, Boolean needAudit, Integer storeType,String mediaId,String groupId,boolean isUpgrade,Boolean advertiserNeedAudit) {
        this.type = type;
        this.name = name;
        this.needAudit = needAudit;
        this.storeType = storeType;
        this.mediaId = mediaId;
        this.groupId = groupId;
        this.isUpgrade = isUpgrade;
        this.advertiserNeedAudit = advertiserNeedAudit;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Boolean getNeedAudit() {
        return needAudit;
    }

    public String getMediaId() {
        return mediaId;
    }

    public String getGroupId() {
        return groupId;
    }

    public boolean isUpgrade() {
        return isUpgrade;
    }

    public Boolean getAdvertiserNeedAudit() {
        return advertiserNeedAudit;
    }

    public boolean sameAdxType(Integer type) {
        return !Objects.isNull(type) && Objects.equals(this.type, type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type)
                ? null
                : Stream.of(AdxTypeEnum.values())
                .filter(item -> Objects.equals(item.getType(), type))
                .findFirst().orElse(null);
    }

    /**
     * 判断当前传入的adx类型是否需要审核
     *
     * @param adxType
     * @return
     */
    public static Boolean needAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType.equals(adxTypeEnum.getType())) {
                return adxTypeEnum.getNeedAudit();
            }
        }
        return false;
    }

    /**
     * 判断所有adx平台类型是否包含传入的adxType
     *
     * @param adxType
     * @return
     */
    public static Boolean contains(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType == adxTypeEnum.getType()) {
                return true;
            }
        }
        return false;
    }

    /**
     * 根据type获取平台类型
     *
     * @param type
     * @return
     */
    public static AdxTypeEnum getEnumByType(Integer type) {
        for (AdxTypeEnum typeEnum : AdxTypeEnum.values()) {
            if (type == typeEnum.getType()) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 根据adxName获取adxType
     * @param adxName 名称
     * @return 编码值
     */
    public static Integer getAdxType(String adxName){
        if(StringUtils.isBlank(adxName)){return 0;}
        for(AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()){
            if(adxTypeEnum.getName().equals(adxName)){
                return adxTypeEnum.getType();
            }
        }
        return 0;
    }

    /**
     * 功能描述 判断广告主是否需要送审
     * @author shenjiaqing
     * @date 17:17 2020/3/27
     * @param adxType
     * @return java.lang.Boolean
     **/
    public static Boolean advertiserNeedAudit(Integer adxType){
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType.equals(adxTypeEnum.getType())) {
                return adxTypeEnum.getAdvertiserNeedAudit();
            }
        }
        return false;
    }

}
