package cn.com.duiba.tuia.activity.center.api.constant.adx;

import lombok.Getter;

import java.util.Objects;

/**
 * @author shenjiaqing
 * @description
 * @data 2020/5/25
 */
public enum AdxFilterLogTypeEnum {

    DO_NOT_FILTER("1.1.0", "不过滤"),
    RESOURCE_LOCATION_BUDGET_FILTER("1.1.1", "资源位预算过滤"),
    FRONT_FLOW_FILTER("1.1.2", "前置流量过滤"),
    RESOURCE_LOCATION_TIME_SLOT_FILTER("1.1.3", "资源位投放时段过滤"),
    RESOURCE_LOCATION_DATA_FILTER("1.1.4", "资源位投放日期过滤"),
    OPERATING_SYSTEM_FILTER("1.1.5", "创意操作系统过滤"),
    STYLE_FILTER("1.1.6", "创意样式过滤"),
    SIZE_DURATION_FILTER("1.1.7", "创意尺寸时长过滤"),
    FREQUENCY_LIMITED_FILTER("1.1.8", "创意频率限制过滤"),
    CUSTOM_FILTER_FILTER("1.1.9", "创意自定义过滤"),
    PLACEMENT_AREA_FILTER("1.1.10", "创意投放地域过滤"),
    BUDGET_FILTER("1.1.11", "预算过滤"),
    BASE_PRICE_FILTER("1.1.12", "底价过滤"),
    NO_RESOURCE_IDEA("1.1.13", "资源位下没有创意"),
    IDEA_AUDIT_NO_PASS("1.1.14", "创意审核不通过"),
    NO_RESOURCE_LOCATION("1.1.15", "找不到资源位"),
    RESOURCE_IDEA_BUDGET_FILTER("1.1.16", "创意预算过滤"),
    AD_SPACE_TYPE_TEMPLATE_FILTER("1.1.17", "广告位类型模板过滤"),
    RESOURCE_IDEA_NOT_RECOMMENDED("1.1.18", "创意不推荐"),

    ;


    /**
     * 编码
     */
    @Getter
    private String code;

    /**
     * 描述
     */
    @Getter
    private String desc;


    AdxFilterLogTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(String code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (AdxFilterLogTypeEnum adxFilterLogTypeEnum : AdxFilterLogTypeEnum.values()) {
            if (adxFilterLogTypeEnum.getCode().equals(code)) {
                return adxFilterLogTypeEnum.getDesc();
            }
        }
        return null;
    }






}
