/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqActivityPageQuery.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2017年1月13日下午4:09:36<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.dto.algo;

import cn.com.duiba.tuia.activity.center.api.dto.risk.AuditDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.Objects;

/**
 * 皮肤主标题标定向关系
 *
 * @author: 阿海
 * @create: 2020-01-09 18:19
 */
@Data
@ToString
@EqualsAndHashCode(callSuper = false)
public class ActivitySkinTitleOrientDTO extends AuditDto {

    /**
     * 主键
     */
    private Long id;
    /**
     * 主标题id
     */
    private Long titleId;
    /**
     * 标题内容
     */
    private String titleContent;

    /**
     * 标题内容长度，string的数字，如6.5
     */
    private String titleContentLength;

    /**
     * 定向关系类型，1皮肤，2行业
     */
    private Integer orientType;
    /**
     * 定向id，皮肤id，行业id
     */
    private String orientId;
    /**
     * 不是该定向id
     */
    private String orientIdNot;
    /**
     * 定向名称，皮肤名称，行业名称
     */
    private String orientName;
    /**
     * 记录创建时间
     */
    private Date gmtCreate;
    /**
     * 记录修改时间
     */
    private Date gmtModified;
    /**
     * 是否删除（1：删除 0：正常，上线）
     */
    private Integer isDeleted;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ActivitySkinTitleOrientDTO that = (ActivitySkinTitleOrientDTO) o;
        return Objects.equals(orientId, that.orientId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orientId);
    }
}
