package cn.com.duiba.tuia.activity.center.api.constant.adx;

import lombok.Getter;

import java.util.Objects;

/**
 * @author shenjiaqing
 * @description
 * @data 2020/5/25
 */
public enum AdxFilterLogTypeEnum {

    DO_NOT_FILTER("1.1.0", "不过滤"),
    FRONT_FLOW_FILTER("1.1.1", "前置流量过滤"),
    NO_RESOURCE_LOCATION("1.1.2", "找不到资源位"),
    POPULAR_GROUP_CLOSED("1.1.3", "推广组未开启"),
    RESOURCE_LOCATION_CLOSED("1.1.4", "资源位未开启"),
    RESOURCE_LOCATION_DATA_FILTER("1.1.5", "资源位投放日期过滤"),
    RESOURCE_LOCATION_TIME_SLOT_FILTER("1.1.6", "资源位投放时段过滤"),
    RESOURCE_LOCATION_BUDGET_FILTER("1.1.7", "资源位预算过滤"),
    AD_SPACE_TYPE_TEMPLATE_FILTER("1.1.8", "广告位类型模板过滤"),
    NO_RESOURCE_IDEA("1.1.9", "资源位下没有创意"),
    IDEA_AUDIT_NO_PASS("1.1.10", "创意审核不通过"),
    OPERATING_SYSTEM_FILTER("1.1.11", "创意操作系统过滤"),
    AD_SPACE_STYLE_TEMPLATE_FILTER("1.1.12", "广告位样式模板过滤"),
    SIZE_DURATION_FILTER("1.1.13", "创意尺寸时长过滤"),
    FREQUENCY_LIMITED_FILTER("1.1.14", "创意频率限制过滤"),
    CUSTOM_FILTER_FILTER("1.1.15", "创意自定义过滤"),
    PLACEMENT_AREA_FILTER("1.1.16", "创意投放地域过滤"),
    RESOURCE_IDEA_BUDGET_FILTER("1.1.17", "创意预算过滤"),
    ORDER_CHOICE_RESOURCE_IDEA_FILTER("1.1.18", "依次筛选创意过滤"),
    PROPORTION_CHOICE_RESOURCE_IDEA_FILTER("1.1.19", "按比例筛选创意过滤"),
    ALG_CHOICE_RESOURCE_IDEA_FILTER("1.1.20", "算法1.0筛选创意过滤"),
    ALG_CHOICE_PLUS_RESOURCE_IDEA_FILTER("1.1.21", "算法2.0筛选创意过滤"),
    FLOW_ESTIMATE_FILTER("1.1.22", "流量预估过滤"),
    NO_NOT_OFFER("1.1.23", "创意不出价"),
    BASE_PRICE_FILTER("1.1.24", "底价过滤"),
    PD_INTERACT_DECISION_FILTER("1.1.25", "PD互动决策过滤"),

    ;


    /**
     * 编码
     */
    @Getter
    private String code;

    /**
     * 描述
     */
    @Getter
    private String desc;


    AdxFilterLogTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(String code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (AdxFilterLogTypeEnum adxFilterLogTypeEnum : AdxFilterLogTypeEnum.values()) {
            if (adxFilterLogTypeEnum.getCode().equals(code)) {
                return adxFilterLogTypeEnum.getDesc();
            }
        }
        return null;
    }






}
