/**
 * Project Name:manager-domain<br>
 * File Name:AppDataRsp.java<br>
 * Package Name:cn.com.duiba.tuia.manager.rsp<br>
 * Date:2016年10月26日下午8:01:24<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.List;

/**
 * ClassName: JmTagLevelDto <br/>
 * Function: 新标签信息. <br/>
 * date: 2020年6月19日 上午10:37:37 <br/>
 *
 * @author lijian
 * @since JDK 1.8
 */
public class JmTagLevelDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /**
     * 标签名称
     */
    private String tagName;

    /**
     * 标签编号
     */
    private String tagNum;

    /**
     * 上级节点
     */
    private Long parentId;

    /**
     * 标签对应的广告id
     */
    private Integer tagLevel;

    /**
     * 子标签
     */
    private List<JmTagLevelDto> children;

    public JmTagLevelDto(String tagName, String tagNum, Long parentId, Integer tagLevel) {
        super();
        this.tagName = tagName;
        this.tagNum = tagNum;
        this.parentId = parentId;
        this.tagLevel = tagLevel;
    }

    public JmTagLevelDto() {
        super();
    }

    /**
     * tagName.
     *
     * @return the tagName
     * @since JDK 1.8
     */
    public String getTagName() {
        return tagName;
    }

    /**
     * tagName.
     *
     * @param tagName the tagName to set
     * @since JDK 1.8
     */
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    /**
     * tagNum.
     *
     * @return the tagNum
     * @since JDK 1.8
     */
    public String getTagNum() {
        return tagNum;
    }

    /**
     * tagNum.
     *
     * @param tagNum the tagNum to set
     * @since JDK 1.8
     */
    public void setTagNum(String tagNum) {
        this.tagNum = tagNum;
    }

    /**
     * parentId.
     *
     * @return the parentId
     * @since JDK 1.8
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parentId.
     *
     * @param parentId the parentId to set
     * @since JDK 1.8
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    /**
     * tagLevel.
     *
     * @return the tagLevel
     * @since JDK 1.8
     */
    public Integer getTagLevel() {
        return tagLevel;
    }

    /**
     * tagLevel.
     *
     * @param tagLevel the tagLevel to set
     * @since JDK 1.8
     */
    public void setTagLevel(Integer tagLevel) {
        this.tagLevel = tagLevel;
    }

    /**
     * children.
     *
     * @return the children
     * @since JDK 1.8
     */
    public List<JmTagLevelDto> getChildren() {
        return children;
    }

    /**
     * children.
     *
     * @param children the children to set
     * @since JDK 1.8
     */
    public void setChildren(List<JmTagLevelDto> children) {
        this.children = children;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
