package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;

import java.util.List;

/**
 * ClassName: ActivitySkinDataDto <br/>
 * Function: 活动皮肤Dto. <br/>
 * date: 2017年2月24日 下午2:54:49 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class ActivitySkinDataDto extends BaseDto {

    private static final long serialVersionUID = -4872868154969983034L;

    public static final ActivitySkinDataDto EMPTY_DTO = new ActivitySkinDataDto(true);

    private Long              id;
    private Long              activityId;                              // 活动id
    private Integer           templateType;                            // 模板type <=> 活动类型
    private String            skinType;                                // 皮肤type
    private Integer           joinInType;                              // 皮肤type
    private String            dataJson;
    private Integer           newLayerRate;                            // 新弹层占比
    private Long              aLayerId;                                // a弹层id
    private Long              bLayerId;                                // b弹层id

    private Integer           activitySkinType;                      //活动大类
    private Integer           activitySecondType;                    //活动小类
    private Integer           secondOpen;                              //二次增值开关
    private Integer           secondCollectAll;                        //二次开关触发次数

    private Integer           isLayer;

    private Integer           isFirstTicket;

    private List<SkinLayerDto> layerList;

    private Integer isShowTitleFirst; // 是否展示主标题（默认0不展示,1展示）
    private Integer titleFirstLength; // 主标题长度限制（12字数之内，英文0.5中文1）")
    private Integer isShowTitleSecond;
    private Integer titleSecondLength;

    /** 是否支持预发券，0-否，1-是 */
    private Integer isPreAdvert;
    /** 预发券数量 */
    private Integer preAdvertNum;
    /** 新行业标签名称 */
    private String industryTagName;
    /** 活动奖品上限 */
    private Integer maxAwards;

    /** 特殊客服样式 当前只为联通 */
    private Integer speKeFuStyle;

    /** 组件化比气体开关 */
    private Integer subSwitch;

    public ActivitySkinDataDto() {

    }

    private ActivitySkinDataDto(boolean isEmpty) {
        super(isEmpty);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public String getSkinType() {
        return skinType;
    }

    public void setSkinType(String skinType) {
        this.skinType = skinType;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public Integer getNewLayerRate() {
        return newLayerRate;
    }

    public void setNewLayerRate(Integer newLayerRate) {
        this.newLayerRate = newLayerRate;
    }

    public Long getaLayerId() {
        return aLayerId;
    }

    public void setaLayerId(Long aLayerId) {
        this.aLayerId = aLayerId;
    }

    public Long getbLayerId() {
        return bLayerId;
    }

    public void setbLayerId(Long bLayerId) {
        this.bLayerId = bLayerId;
    }

    public List<SkinLayerDto> getLayerList() {
        return layerList;
    }

    public void setLayerList(List<SkinLayerDto> layerList) {
        this.layerList = layerList;
    }

    public Integer getActivitySkinType() {
        return activitySkinType;
    }

    public void setActivitySkinType(Integer activitySkinType) {
        this.activitySkinType = activitySkinType;
    }

    public Integer getActivitySecondType() {
        return activitySecondType;
    }

    public void setActivitySecondType(Integer activitySecondType) {
        this.activitySecondType = activitySecondType;
    }

    public Integer getJoinInType() {
        return joinInType;
    }

    public void setJoinInType(final Integer joinInType) {
        this.joinInType = joinInType;
    }

    public Integer getIsLayer() {
        return isLayer;
    }

    public void setIsLayer(Integer isLayer) {
        this.isLayer = isLayer;
    }

    public Integer getSecondOpen() {
        return secondOpen;
    }

    public void setSecondOpen(final Integer secondOpen) {
        this.secondOpen = secondOpen;
    }

    public Integer getSecondCollectAll() {
        return secondCollectAll;
    }

    public void setSecondCollectAll(final Integer secondCollectAll) {
        this.secondCollectAll = secondCollectAll;
    }

    public Integer getIsFirstTicket() {
        return isFirstTicket;
    }

    public void setIsFirstTicket(Integer isFirstTicket) {
        this.isFirstTicket = isFirstTicket;
    }

    public Integer getIsShowTitleFirst() {
        return isShowTitleFirst;
    }

    public void setIsShowTitleFirst(Integer isShowTitleFirst) {
        this.isShowTitleFirst = isShowTitleFirst;
    }

    public Integer getTitleFirstLength() {
        return titleFirstLength;
    }

    public void setTitleFirstLength(Integer titleFirstLength) {
        this.titleFirstLength = titleFirstLength;
    }

    public Integer getIsShowTitleSecond() {
        return isShowTitleSecond;
    }

    public void setIsShowTitleSecond(Integer isShowTitleSecond) {
        this.isShowTitleSecond = isShowTitleSecond;
    }

    public Integer getTitleSecondLength() {
        return titleSecondLength;
    }

    public void setTitleSecondLength(Integer titleSecondLength) {
        this.titleSecondLength = titleSecondLength;
    }

    public Integer getIsPreAdvert() {
        return isPreAdvert;
    }

    public void setIsPreAdvert(Integer isPreAdvert) {
        this.isPreAdvert = isPreAdvert;
    }

    public Integer getPreAdvertNum() {
        return preAdvertNum;
    }

    public void setPreAdvertNum(Integer preAdvertNum) {
        this.preAdvertNum = preAdvertNum;
    }

    public String getIndustryTagName() {
        return industryTagName;
    }

    public void setIndustryTagName(String industryTagName) {
        this.industryTagName = industryTagName;
    }

    public Integer getMaxAwards() {
        return maxAwards;
    }

    public void setMaxAwards(Integer maxAwards) {
        this.maxAwards = maxAwards;
    }

    public Integer getSpeKeFuStyle() {
        return speKeFuStyle;
    }

    public void setSpeKeFuStyle(final Integer speKeFuStyle) {
        this.speKeFuStyle = speKeFuStyle;
    }

    public Integer getSubSwitch() {
        return subSwitch;
    }

    public void setSubSwitch(Integer subSwitch) {
        this.subSwitch = subSwitch;
    }
}
