package cn.com.duiba.tuia.activity.center.api.remoteservice.subtitle;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.subtitle.SubComposeDTO;
import cn.com.duiba.tuia.activity.center.api.dto.subtitle.SubDTO;
import cn.com.duiba.tuia.activity.center.api.dto.subtitle.SubPrizeTitleMaterielDTO;

import java.util.List;
import java.util.Map;

/**
 * 算法标题
 */
@AdvancedFeignClient
public interface RemoteSubAlgoService {

    /**
     * 获取开放广告位列表
     *
     * @return 暂时来自Apollo
     */
    List<Long> getSubSlotList();

    /**
     * 【入参】广告位+活动
     *
     * @return 可投奖品300List 和 可投主标题130List
     **/
    SubPrizeTitleMaterielDTO getActivityPrizeTitle(Long slotId, Long actId);

    /**
     * 【入参】mainTitleIds 主标题 20个
     *
     * @return 主副标题组合 20 * 130
     **/
    Map<Long, List<Long>> getMainTitleSubTitleMapList(List<Long> mainTitleIds);

    /**
     * 组件化组合List<DTO>*10,每个DTO属性如下：
     * req subActivity 1个活动集
     * prizeComposeList 10组奖品集合
     * titleComposeList 1组主副标题集合
     * 增加组合校验
     *
     * @param reqList
     * @return 返回10*10的可投组件集合
     */
    List<SubDTO> getFinalSubPrizeTitleList(List<SubComposeDTO> reqList);

    /**
     * 获取所有标签信息
     * @param ids
     * @param type：1主2副标题，3奖品
     * @return
     */
    Map<Long, List<Long>> getTagLibraryDtoList(List<Long> ids, Integer type);
}
