package cn.com.duiba.tuia.activity.center.api.dto.commercial.plant;

import cn.com.duiba.tuia.activity.center.api.constant.ErrorCode;

import java.io.Serializable;

/**
 * [商业化活动]种红包检查Dto
 *
 * @author zhangbaiqiang
 * @date 2019/03/08
 */
public class CheckDto implements Serializable {
    private static final long serialVersionUID = 3815919639518562796L;

    /**
     * 是否成功
     */
    private Boolean success;

    /**
     * 错误码
     */
    private String code;

    /**
     * 错误信息
     */
    private String msg;

    public CheckDto() {
        this.success = true;
        this.code = ErrorCode.E0000000.getErrorCode();
        this.msg = ErrorCode.E0000000.getDesc();
    }

    public CheckDto(ErrorCode errorCode) {
        this.success = false;
        this.code = errorCode.getErrorCode();
        this.msg = errorCode.getDesc();
    }

    public CheckDto(String errorCode, String errorMsg) {
        this.success = false;
        this.code = errorCode;
        this.msg = errorMsg;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
