package cn.com.duiba.tuia.activity.center.api.dto.commodity;

import cn.com.duiba.tuia.activity.center.api.bean.enums.commodity.CommerceTypeEnum;

import java.io.Serializable;

/**
 * @ClassName CommerceGoodsDto
 * @Description 商品信息
 * @Author Zaizai
 * @Date 2020/7/10 3:42 下午
 **/
public class CommerceGoodsDto implements Serializable {

    private Long id;

    /**
     * 商品标题
     */
    private String title;

    /**
     * 商品类型
     * @see CommerceTypeEnum
     */
    private Integer commerceType;

    /**
     * 优惠券抵扣金额，单位:分
     */
    private Long couponAmount;

    /**
     * 成交价，单位:分
     */
    private Long dealAmount;

    /**
     * 商品图片
     */
    private String commerceImgUrl;

    /**
     * 角标图片
     */
    private String cornImgUrl;

    /**
     * 详情图片
     */
    private String detailImgUrl;

    /**
     * 物流文案
     */
    private String logisticsDoc;

    /**
     * 其他文案
     */
    private String otherDoc;

    /**
     * 商品规格
     */
    private String quantity;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getCommerceType() {
        return commerceType;
    }

    public void setCommerceType(Integer commerceType) {
        this.commerceType = commerceType;
    }

    public Long getCouponAmount() {
        return couponAmount;
    }

    public void setCouponAmount(Long couponAmount) {
        this.couponAmount = couponAmount;
    }

    public Long getDealAmount() {
        return dealAmount;
    }

    public void setDealAmount(Long dealAmount) {
        this.dealAmount = dealAmount;
    }

    public String getCommerceImgUrl() {
        return commerceImgUrl;
    }

    public void setCommerceImgUrl(String commerceImgUrl) {
        this.commerceImgUrl = commerceImgUrl;
    }

    public String getCornImgUrl() {
        return cornImgUrl;
    }

    public void setCornImgUrl(String cornImgUrl) {
        this.cornImgUrl = cornImgUrl;
    }

    public String getDetailImgUrl() {
        return detailImgUrl;
    }

    public void setDetailImgUrl(String detailImgUrl) {
        this.detailImgUrl = detailImgUrl;
    }

    public String getLogisticsDoc() {
        return logisticsDoc;
    }

    public void setLogisticsDoc(String logisticsDoc) {
        this.logisticsDoc = logisticsDoc;
    }

    public String getOtherDoc() {
        return otherDoc;
    }

    public void setOtherDoc(String otherDoc) {
        this.otherDoc = otherDoc;
    }

    public String getQuantity() {
        return quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }
}
