/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.util.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.PutRatioDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceLocationDto;
import cn.com.duiba.tuia.activity.center.api.util.CollectionTool;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AdxUtils {
    private static final int YUN_FEN_CON = 100;

    private AdxUtils() {
    }

    public static boolean checkRatioEquesFull(List<PutRatioDto> putRatioDtos) {
        if (CollectionTool.isEmpty(putRatioDtos)) {
            return false;
        }
        int sumRatio = putRatioDtos.stream().filter(ratio -> ratio != null).mapToInt(ratio -> ratio.getPutRatio() != null ? ratio.getPutRatio() : 0).sum();
        return 100 == sumRatio;
    }

    public static int getPutRatio(PutRatioDto putRatioDto) {
        return !Objects.isNull(putRatioDto) && !Objects.isNull(putRatioDto.getPutRatio()) && putRatioDto.getPutRatio() > 0 ? putRatioDto.getPutRatio() : 0;
    }

    public static long convertParPrice(ResourceIdeaDto resourceIdeaDto) {
        if (!Objects.isNull(resourceIdeaDto) && !Objects.isNull(resourceIdeaDto.getIdeaPrice())) {
            return BigDecimal.valueOf(100L).multiply(BigDecimal.valueOf(resourceIdeaDto.getIdeaPrice())).longValue();
        }
        return 0L;
    }

    public static long convertParPrice(Double dbPrice) {
        if (!Objects.isNull(dbPrice)) {
            return BigDecimal.valueOf(100L).multiply(BigDecimal.valueOf(dbPrice)).longValue();
        }
        return 0L;
    }

    public static double convertParPriceToCpm(long cpmPrice) {
        return BigDecimal.valueOf(cpmPrice).divide(BigDecimal.valueOf(100L), 4, 2).doubleValue();
    }

    public static int convertBillType(ResourceLocationDto resourceLocationDto) {
        if (Objects.nonNull(resourceLocationDto) && StringUtils.isNotBlank((CharSequence)resourceLocationDto.getPayType())) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"CPC", (CharSequence)resourceLocationDto.getPayType())) {
                return 0;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"CPM", (CharSequence)resourceLocationDto.getPayType())) {
                return 1;
            }
        }
        return -1;
    }
}

