package cn.com.duiba.tuia.activity.center.api.constant.adx;

import lombok.Getter;

public enum AdxFlowLinkTypeEnum {

    RESOURCE_LOCATION_EFFECTIVE_FILTER("resource_effective_f", "有效资源位过滤"),
    POPULAR_GROUP_STATUS_IS_OPEN_FILTER("group_status_f", "推广组状态过滤"),
    RESOURCE_LOCATION_STATUS_IS_OPEN_FILTER("resource_status_f", "资源位状态过滤"),
    RESOURCE_LOCATION_DATA_TIME_FILTER("resource_put_in_time_f", "资源位投放日期时段过滤"),
    RESOURCE_LOCATION_BUDGET_FILTER("resource_budget_f", "资源位预算过滤"),
    RESOURCE_LOCATION_TYPE_TEMPLATE_FILTER("resource_type_f", "资源位类型模板过滤"),
    RESOURCE_LOCATION_STYLE_TEMPLATE_FILTER("resource_style_f", "资源位样式模板过滤"),
    FRONT_FLOW_FILTER("front_flow_f", "前置流量过滤"),
    RESOURCE_LOCATION_CROWDS_FILTER("resource_crowds_f", "人群过滤"),
    RESOURCE_IDEA_EFFECTIVE_COLLECTION_FILTER("idea_effective_collection_f", "有效创意集过滤"),
    RESOURCE_IDEA_AUDIT_STATUS_FILTER("idea_audit_status_f", "创意审核状态过滤"),
    RESOURCE_IDEA_CROWD_FILTER("idea_crowds_f", "创意人群过滤"),
    RESOURCE_IDEA_OPERATING_SYSTEM_FILTER("idea_operating_system_f", "创意操作系统过滤"),
    RESOURCE_IDEA_STYLE_FILTER("idea_style_f", "创意样式过滤"),
    RESOURCE_IDEA_SIZE_DURATION_FILTER("idea_size_duration_f", "创意尺寸时长过滤"),
    RESOURCE_IDEA_EXPOSURE_FREQUENCY_FILTER("idea_exposure_frequency_f", "创意曝光频次过滤"),
    RESOURCE_IDEA_CUSTOM_FILTER("idea_custom_f", "创意自定义过滤"),
    RESOURCE_IDEA_REGION_FILTER("idea_region_f", "创意地域过滤"),
    RESOURCE_IDEA_BUDGET_FILTER("idea_budget_f", "创意预算过滤"),
    RESOURCE_IDEA_CHOICE_FILTER("idea_choice_f", "创意筛选过滤"),
    RESOURCE_IDEA_FLOW_ESTIMATE_FILTER("idea_flow_estimate_f", "流量预过滤"),
    ALG_DECISION_FILTER("alg_decision_f", "算法决策过滤"),
    BASE_PRICE_FILTER("base_price_f", "底价过滤"),
    OFFER_PRICE_FILTER("offer_price_f", "创意出价"),
    BUILD_ADVERT_FILTER("build_advert_f",  "封装广告物料"),
    PRE_ADVERT_FILTER("pre_advert_filter", "预发券过滤"),
    GENERATE_DIRECT_ORDER_FILTER("generate_direct_order_filter", "生成直投广告订单过滤"),
    DIRECT_ADVERT_FILTER("direct_advert_filter", "直投获取广告失败"),


    ;


    /**
     * 编码
     */
    @Getter
    private String code;

    /**
     * 描述
     */
    @Getter
    private String desc;

    AdxFlowLinkTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
