package cn.com.duiba.tuia.activity.center.api.constant.algo;


import java.util.HashSet;
import java.util.Set;

/**
 * 算法标题行业定向
 */
public enum AlgoTitleTypeEnum {
    TITLE_FIRST_MAIN(1, "主标题"),
    TITLE_SECOND_SUB(2, "副标题");

    private Integer type;

    private String desc;


    AlgoTitleTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static Set<Integer> getTypes() {
        Set<Integer> types = new HashSet<>();
        for (AlgoTitleTypeEnum value : AlgoTitleTypeEnum.values()) {
            types.add(value.type);
        }

        return types;
    }
}
