package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.PrizeDto;
import cn.com.duiba.tuia.activity.center.api.dto.PrizeQueryDTO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;


/**
 * ClassName: RemotePrizeService <br/>
 * Function: 奖项库相关服务. <br/>
 * Reason: . <br/>
 * date: 2017年6月1日 上午10:45:53 <br/>
 *
 * @author wubo
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemotePrizeService {
    
    /**
     * selectPrizeById:(根据id查询). <br/>
     * @param id 奖品id
     * @param includeStock 是否查询库存值(web查询不包含传false，manager查询可包含传true)
     * @return 奖品dto
     */
    DubboResult<PrizeDto> selectPrizeById(Long id,Boolean includeStock);
    
    /**
     * savePrize:(保存奖项). <br/>
     * 有id更新，无id新增。<br/>
     * 新增奖项时，stockChange=库存. <br/>
     * 更新奖项时，stockChange=库存变化值=新设置的库存-老的库存值
     * @param dto 奖品dto
     * @return 奖品id
     */
    DubboResult<Long> savePrize(PrizeDto dto);

    /**
     * 更新奖品信息
     * （只更新奖品表）
     * @param dto dto
     * @return 更新数量
     */
    DubboResult<Integer> updatePrize(PrizeDto dto);
    
    /**
     * deletePrize:(根据id删除，软删). <br/>
     * @param id 奖品id
     * @return boolean
     */
    DubboResult<Boolean> deletePrize(Long id);   
    
    /**
     * selectList:(分页查询). <br/>
     * @param id 奖品id
     * @param title 奖品名称
     * @param offset offset
     * @param max max
     * @param includeStock 是否包含库存信息
     * @return PageDto<PrizeDto>
     */
    @RequestMapping("selectListStock")
    DubboResult<PageDto<PrizeDto>> selectList(Long id,String title,Integer offset,Integer max,Boolean includeStock);

    /**
     * 分页查询
     * @param id 奖品id
     * @param title 奖品名称
     * @param prizeType 奖品类型
     * @param offset offset
     * @param max max
     * @param includeStock 是否包含库存信息
     * @return PageDto<PrizeDto>
     */
    DubboResult<PageDto<PrizeDto>> selectList(Long id,String title,String prizeType,Integer offset,Integer max,Boolean includeStock);

    DubboResult<PageDto<PrizeDto>> getPageList(PrizeQueryDTO dto);

    /**
     * 活动请求奖品库奖品接口.
     * 校验奖品库存 并扣除库存
     * 兼容处理
     * @param prizeId: 奖品ID
     * @param num: num 为null时候扣去1个库存,不为null则扣去num个
    */
    DubboResult<PrizeDto> obtainPrizeNew(Long prizeId,String orderId, Integer num);

    /**
     * 活动请求奖品库奖品接口.
     * 校验奖品库存 并扣除库存
     * @param prizeId: 奖品ID
     * @param num: num 为null时候扣去1个库存,不为null则扣去num个
     */
    DubboResult<PrizeDto> obtainPrize(Long prizeId,String orderId, Integer num);

    /**
     * 查询支付宝奖品
     * @return dto
     */
    DubboResult<PrizeDto> selectAlipayPrize();

    DubboResult<PrizeDto> getPrize(Long id,String prizeType,Boolean includeStock);

    /**
     * 查询支付宝奖品
     * @return dto
     */
    DubboResult<PrizeDto> selectQBPrize();

    /**
     * 根据id批量查询
     *
     * @param ids
     * @return
     */
    DubboResult<List<PrizeDto>> selectByIds(List<Long> ids);

    /**
     * 根据奖品类型查询
     * @param prizeType 奖品类型
     * @return
     */
    List<PrizeDto> selectByType(String prizeType);

    /**
     * 校验 奖品配置的瓜分红包直投页是否使用过
     *
     * 一个瓜分红包直投页只能配置在一个 奖品上
     * @param pageId
     * @return
     */
    Boolean checkRedPacketPageUsed(Long pageId);

    /**
     * 查询所有含有奖品描述的奖品
     * @return
     */
    List<PrizeDto> listHasDescPrize();

    /**
     * 根据奖品ID查询
     * @param ids
     * @return
     */
    List<PrizeDto> selectListByIds(List<Long> ids);
}
