package cn.com.duiba.tuia.activity.center.api.dto.downloadocpc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @description    <p>网服开户用户点击信息对象
 * @author cuiwx
 * @version 1.0 2021/9/26
 */
@ApiModel
public class DownLoadOcpcRecordDTO implements Serializable {

    @ApiModelProperty(value = "数据库自增id")
    private Long id;

    @ApiModelProperty(value = "用户点击Id", required = true)
    @NotNull
    private String clickId;

    @ApiModelProperty(value = "百度上报携带，透传百度字段，经过URLENCODE")
    private String extInfo;

    @ApiModelProperty(value = "我方在媒体后台的用户id，百度根据该字段取盘古配置akey，对信息做md5")
    private String userId;

    @ApiModelProperty(value = "平台标识,{@link DownLoadOcpcPlatFormEnum}")
    private Byte platForm;

    @ApiModelProperty(value = "记录创建时间")
    private Date gmtCreate;

    @ApiModelProperty(value = "记录修改时间")
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClickId() {
        return clickId;
    }

    public void setClickId(String clickId) {
        this.clickId = clickId;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Byte getPlatForm() {
        return platForm;
    }

    public void setPlatForm(Byte platForm) {
        this.platForm = platForm;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
