/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum ActivityOptionType {
    TYPE_COUPON("coupon", "\u4f18\u60e0\u5238"),
    TYPE_LUCKY("lucky", "\u798f\u888b"),
    TYPE_NOTHING("nothing", "\u4e0d\u5173\u8054\u5956\u54c1"),
    TYPE_THANKS("thanks", "\u8c22\u8c22\u53c2\u4e0e"),
    TYPE_AGAIN("again", "\u518d\u6765\u4e00\u6b21"),
    TYPE_PHYSICAL("physical", "\u5b9e\u7269"),
    TYPE_ALIPAY("alipay", "\u652f\u4ed8\u5b9d\u76f4\u5145"),
    TYPE_VIRTUAL("virtual", "\u865a\u62df\u5956\u54c1"),
    TYPE_QB("qb", "Q\u5e01"),
    TYPE_BILL("bill", "\u8bdd\u8d39"),
    TYPE_RANDOM_COIN("randomCoin", "\u968f\u673a\u91d1\u5e01"),
    TYPE_LARGE_COUPON("large_coupon", "\u5927\u989d\u5238"),
    TYPE_WECHATPAY("wechatpay", "\u5fae\u4fe1\u76f4\u5145");

    private String code;
    private String desc;
    private static Set<String> stockType;

    private ActivityOptionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean equalsCode(String type) {
        return this.code.equals(type);
    }

    public static String getDescByCode(String code) {
        String desc = "";
        for (ActivityOptionType temp : ActivityOptionType.values()) {
            if (!temp.getCode().equals(code)) continue;
            desc = temp.getDesc();
        }
        return desc;
    }

    public static ActivityOptionType getByCode(String code) {
        for (ActivityOptionType temp : ActivityOptionType.values()) {
            if (!temp.getCode().equals(code)) continue;
            return temp;
        }
        return null;
    }

    public static boolean isStockType(String type) {
        return stockType.contains(type);
    }

    public static String getStockMsg(String type) {
        if (StringUtils.isNotBlank((CharSequence)type) && ("virtual".equals(type) || "physical".equals(type) || "coupon".equals(type) || "alipay".equals(type) || "qb".equals(type) || "bill".equals(type) || "wechatpay".equals(type))) {
            String msg = "\u5956\u54c1\u7c7b\u578b\uff1a" + (Object)((Object)ActivityOptionType.getByCode(type)) + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u5c3d\u5feb\u586b\u5145\u5e93\u5b58\uff1b\u4eca\u65e5\u4e0d\u518d\u62a5\u8b66\u6309\u94ae";
            return msg;
        }
        return "";
    }

    static {
        stockType = new HashSet<String>();
        stockType.add(ActivityOptionType.TYPE_COUPON.code);
        stockType.add(ActivityOptionType.TYPE_ALIPAY.code);
        stockType.add(ActivityOptionType.TYPE_PHYSICAL.code);
        stockType.add(ActivityOptionType.TYPE_VIRTUAL.code);
        stockType.add(ActivityOptionType.TYPE_QB.code);
        stockType.add(ActivityOptionType.TYPE_BILL.code);
        stockType.add(ActivityOptionType.TYPE_WECHATPAY.code);
    }
}

