/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.common;

import cn.com.duiba.tuia.activity.center.api.common.OrderBy;
import cn.com.duiba.tuia.activity.center.api.common.Pageable;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class PageRequest
implements Pageable,
Serializable {
    private static final long serialVersionUID = -3990989391042856586L;
    public static final Integer DEFAULT_OFFSET = 0;
    public static final Integer DEFAULT_PAGE_SIZE = 200;
    private Integer offset;
    private Integer pageSize;
    private List<OrderBy> orderByList;

    public static PageRequest of(int offset, int size) {
        return PageRequest.of(offset, size, Collections.emptyList());
    }

    public static PageRequest of(int offset, int size, OrderBy orderBy) {
        return PageRequest.newPageRequest(offset, size, Collections.singletonList(orderBy));
    }

    public static PageRequest of(int offset, int size, List<OrderBy> orderByList) {
        return PageRequest.newPageRequest(offset, size, orderByList);
    }

    public static PageRequest of(int offset, int size, OrderBy.Direction direction, String ... columnNames) {
        return PageRequest.of(offset, size, OrderBy.by(direction, columnNames));
    }

    static PageRequest newPageRequest(int offset, int size, List<OrderBy> orderByList) {
        PageRequest pageRequest = new PageRequest();
        pageRequest.setOffset(offset);
        pageRequest.setPageSize(size);
        pageRequest.setOrderByList(orderByList);
        return pageRequest;
    }

    public String toString() {
        return String.format("Page request [offset %d, size: %s]", this.getOffset(), this.getPageSize());
    }

    @Override
    public List<OrderBy> getSort() {
        return this.orderByList;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    @Override
    public Integer getPageSize() {
        return this.pageSize;
    }

    public List<OrderBy> getOrderByList() {
        return this.orderByList;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setOrderByList(List<OrderBy> orderByList) {
        this.orderByList = orderByList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        List<OrderBy> this$orderByList = this.getOrderByList();
        List<OrderBy> other$orderByList = other.getOrderByList();
        return !(this$orderByList == null ? other$orderByList != null : !((Object)this$orderByList).equals(other$orderByList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        List<OrderBy> $orderByList = this.getOrderByList();
        result = result * 59 + ($orderByList == null ? 43 : ((Object)$orderByList).hashCode());
        return result;
    }
}

