package cn.com.duiba.tuia.activity.center.api.constant.downloadocpc;

import lombok.Getter;

import java.util.Objects;

/**
 * @author cuiwx
 * @version 1.0 2021/9/26
 * @description <p>网服开户平台枚举类
 */
@Getter
public enum DownLoadOcpcPlatFormEnum {
    BAI_DU_DOWNLOAD("1", "百度网服开户", false),
    GUANG_DIAN_TONG_DOWNLOAD("2", "广点通网服开户", false),
    KUAI_SHOU_DOWNLOAD("3", "快手网服开户", false),
    MANG_GUO_TV_DOWNLOAD("4", "芒果tv网服开户", false),
    QU_TOU_TIAO_DOWNLOAD("5", "趣头条网服开户", false),
    IQIYI_DOWNLOAD("6", "爱奇艺网服开户", false),
    OPPO_DOWNLOAD("7", "OPPO网服开户", false),
    JULIANG_DOWNLOAD("8", "巨量网服开户", false),

    /**
     * 程序化采量 - 快手
     */
    PBP_KUAI_SHOU_DOWNLOAD("11", "程序化采量-快手网服开户", true),
    /**
     * 程序化采量 - 爱奇艺
     */
    PBP_IQIYI_DOWNLOAD("12", "程序化采量-爱奇艺", true),
    /**
     * 程序化采量 - 广点通
     */
    PBP_GUANG_DIAN_TONG_DOWNLOAD("13", "程序化采量-广点通", true),
    /**
     * 程序化采量 - 多盟
     */
    PBP_DOMOB_DOWNLOAD("14", "程序化采量-多盟", true),
    /**
     * 程序化采量 - 巨量
     */
    PBP_OCEAN_ENGINE_DOWNLOAD("15", "程序化采量-巨量", true),
    /**
     * 程序化采量 - UC
     */
    PBP_UC_DOWNLOAD("16", "程序化采量-UC", true),
    ;

    private String platForm;
    private String desc;
    private Boolean newVersion;

    DownLoadOcpcPlatFormEnum(String platForm, String desc, boolean newVersion) {
        this.platForm = platForm;
        this.desc = desc;
        this.newVersion = newVersion;
    }

    public static DownLoadOcpcPlatFormEnum getByPlatForm(String platForm) {
        for (DownLoadOcpcPlatFormEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getPlatForm(), platForm)) {
                return typeEnum;
            }
        }
        return null;
    }
}
