package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.algo.PrizeSubTagDTO;

import java.util.List;

/**
 * 奖品组件化标签服务
 * @author miaohongshuai
*/
@AdvancedFeignClient
public interface RemotePrizeSubTagService {

    /**
     * 根据奖品id删除奖品标签
     * @param prizeId
     * @return
     */
    int deleteByPrizeId(Long prizeId);
    /**
     * 保存奖品标签列表
     * @param prizeId
     * @param tags
     * @return
     */
    int savePrizeSubTags(Long prizeId, List<Long> tags);

    /**
     * 根据奖品id获取标签列表
     * @param prizeId
     * @return
     */
    List<Long> listByPrizeId(Long prizeId);

    /**
     * 根据奖品id列表查询 奖品标签关联DTO
     * @param prizeIds
     * @return
     */
    List<PrizeSubTagDTO> listDTOByPrizeIds(List<Long> prizeIds);
}
