package cn.com.duiba.tuia.activity.center.api.dto.oceanengine;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import static cn.com.duiba.tuia.activity.center.api.dto.oceanengine.OceanConstant.*;


/**
 * @author duiba
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OceanRefreshTokenRequest {
    private String secret = SECRET;
    private Long app_id = APP_ID;
    private String grant_type = REFRESH_TOKEN_GRANT_TYPE;
    private String refresh_token;

    public OceanRefreshTokenRequest(OceanTokenRedisDTO tokenInRedis) {
        this.refresh_token = tokenInRedis.getRefreshToken();
    }

    public static OceanRefreshTokenRequest convert(OceanTokenRedisDTO tokenInRedis) {
        OceanRefreshTokenRequest oceanRefreshTokenRequest = new OceanRefreshTokenRequest();
        oceanRefreshTokenRequest.setRefresh_token(tokenInRedis.getRefreshToken());
        return oceanRefreshTokenRequest;

    }
}
