
/**
 * Project Name:activity-center-api<br>
 * File Name:PluginSkinDto.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年5月9日上午10:23:54<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;

import java.util.List;


/**
 * ClassName: PluginSkinDto <br/>
 * 插件工具DTO
 * date: 2017年5月9日 上午10:23:54 <br/>.
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public class PluginSkinDto extends BaseDto {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = -2778920576326686957L;

    /**
     * 主键列表
     */
    private List<Long> idList;

    /** The id. */
    private Long id;

    /** 皮肤名称. */
    private String skinName;

    /** 皮肤适用业务场景(1:插件活动工具). */
    private Integer usageScenario;

    /** 皮肤业务类型，插件活动时无效. */
    private String skinType;

    /** The is deleted. */
    private Boolean isDeleted;
    
    /** 皮肤代码. */
    private String code;



    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }


    /**
     * Gets the id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    
    /**
     * Sets the id.
     *
     * @param id the id
     */
    public void setId(Long id) {
        this.id = id;
    }

    
    /**
     * Gets the skin name.
     *
     * @return the skin name
     */
    public String getSkinName() {
        return skinName;
    }

    
    /**
     * Sets the skin name.
     *
     * @param skinName the skin name
     */
    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    
    /**
     * Gets the usage scenario.
     *
     * @return the usage scenario
     */
    public Integer getUsageScenario() {
        return usageScenario;
    }

    
    /**
     * Sets the usage scenario.
     *
     * @param usageScenario the usage scenario
     */
    public void setUsageScenario(Integer usageScenario) {
        this.usageScenario = usageScenario;
    }

    
    /**
     * Gets the skin type.
     *
     * @return the skin type
     */
    public String getSkinType() {
        return skinType;
    }

    
    /**
     * Sets the skin type.
     *
     * @param skinType the skin type
     */
    public void setSkinType(String skinType) {
        this.skinType = skinType;
    }

    
    /**
     * Gets the is deleted.
     *
     * @return the checks if is deleted
     */
    public Boolean getIsDeleted() {
        return isDeleted;
    }

    
    /**
     * Sets the is deleted.
     *
     * @param isDeleted the checks if is deleted
     */
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }


    
    public String getCode() {
        return code;
    }


    
    public void setCode(String code) {
        this.code = code;
    }
}

