package cn.com.duiba.tuia.activity.center.api.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.*;

/** 签名工具 */
public class SignTool {


    /** 验签方法
     *
     * @param params
     * @return
     */
    public static boolean signVerify(String appSecret,Map<String, String> params){
        Map<String, String> map=new TreeMap<>();
        map.put("appSecret", appSecret);

        for(String key:params.keySet()){
            if(!key.equals("sign")){
                map.put(key, params.get(key));
            }
        }

        String sign=sign(map);
        if(sign.equals(params.get("sign"))){
            return true;
        }
        return false;
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null)
            return "";
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }
    /** 签名方法
     *
     * @param params
     * @return
     */
    public static String sign(Map<String,String> params){
        List<String> keys=new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String string="";
        for(String s:keys){
            string+=params.get(s);
        }
        String sign="";
        try {
            sign = toHexValue(encryptMD5(string.getBytes(Charset.forName("utf-8"))));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("md5 error");
        }
        return sign;
    }

    private static byte[] encryptMD5(byte[] data)throws Exception{
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    public static void main(String[] args) {
        String appKey="key";
        String appSecret="secret";

        Map<String, String> params=new TreeMap<String, String>();
        params.put("appKey", appKey);
        params.put("appSecret", appSecret);
        params.put("date", new Date().getTime()+"");

        String sign=sign(params);

        params.put("sign", sign);

        System.out.println(signVerify(appSecret, params));

    }
}
