package cn.com.duiba.tuia.activity.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
public class ProgrammaticComponentInstanceDto implements Serializable {
    private static final long serialVersionUID = -4225393242184374818L;
    /**
     * 主键，实例id
     */
    private Long id;

    /**
     * 从哪个id复制过来（用于替换时候的映射）
     */
    private String oldId;
    /**
     * 组件id
     */
    private Long componentId;
    /**
     * 程序化活动id
     */
    private Long activityId;
    /**
     * 组件类型
     */
    private Long componentType;
    /**
     * 实例标题名
     */
    private String name;
    /**
     * 实例链接
     */
    private String link;
    /**
     * 创建人id
     */
    private String adminId;
    /**
     * 组件内部结构
     */
    private Object vNode;
    /**
     * 组件内部结构
     */
    private Object docs;
    /**
     * 标签
     */
    private String tags;
    /**
     * 额外数据，json存储，包含激励数据、奖品、增值
     */
    private Object extra;
    /**
     * 绑定的活动
     */
    private String bindActivity;
    /**
     * 类型，1:绑定程序化活动 2:绑定分裂活动
     */
    private Integer bindType;

    /**
     * 组件类型
     */
    private String type;

    /**
     * 是否删除
     */
    private Boolean isDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 父节点
     */
    private Long parentId;
    /**
     * 子节点
     */
    private Long childId;
    /**
     * 前节点
     */
    private Long prevId;
    /**
     * 后节点
     */
    private Long siblingId;

    /**
     * 在树中是否删除
     */
    private Boolean treeDelete;
}
