/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.adx;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public enum AdxTypeEnum {
    LIEBAO(1, "\u730e\u8c79", false, "55287", "3", false),
    SOUGOU(2, "\u641c\u72d7", false, "56100", "10", false),
    MOJI(3, "\u58a8\u8ff9\u5929\u6c14", false, "57045", "11", false),
    BAOFENG(4, "\u66b4\u98ce\u5f71\u97f3", false, "58196", "18", false),
    BAIDU(5, "\u767e\u5ea6\u89c6\u9891", true, "82999", "17", true),
    XIAOMI(6, "\u5c0f\u7c73", false, "58972", "21", false),
    ZHANG_YUE(7, "\u638c\u9605", true, "61112", "31", false),
    NAVIGATION(8, "2345", true, "63596", "42", false),
    LIAN_SHANG(9, "\u8fde\u5c1a", false, "64738", "59", false),
    XIAO_EN_AI(10, "\u5c0f\u6069\u7231", true, "63597", "71", false),
    OPPO(11, "OPPO", true, "66506", "84", false),
    I_QI_YI(12, "\u7231\u5947\u827a-\u8054\u76df", true, "79712", "96", true),
    MEIZU(13, "\u9b45\u65cf", true, "68016", "94", false),
    MONGO_TV(14, "\u8292\u679cTV", true, "69972", "124", false),
    APUS(15, "APUS", true, "69989", "115", false),
    MEI_SHU(16, "\u7f8e\u6570", true, "69822", "118", false),
    LENOVO(17, "\u8054\u60f3", true, "70379", "125", false),
    MOMO(18, "\u964c\u964c", true, "70391", "119", false),
    BAIDU_ALLIANCE(19, "\u767e\u5ea6\u8054\u76df", false, "71092", "129", false),
    IWANVI(20, "\u4e2d\u6587\u4e07\u7ef4", false, "71189", "130", false),
    MOMO_OPEN_SCREEN(21, "\u964c\u964c\u5f00\u5c4f", false, "71941", "134", false),
    QINGTING(22, "\u873b\u8713", false, "73007", "136", false),
    JD_FINANCE(23, "\u4eac\u4e1c\u91d1\u878d", true, "54751", "135", false),
    QUTOUTIAO(24, "\u8da3\u5934\u6761-\u5176\u4ed6\u7cfb\u5217", false, "83064", "155", false),
    RUAN_GAO(25, "\u8f6f\u544a", false, "75699", "139", false),
    XIAN_JIAN(26, "\u5148\u8350", false, "75695", "141", false),
    SOHU(27, "\u641c\u72d0", true, "76366", "140", true),
    QINGTING_2(28, "\u873b\u87132.0", false, "73007", "143", false),
    SIGMOB(29, "sigmob", false, "77448", "144", false),
    I_QI_YI_MAIN(30, "\u7231\u5947\u827a-\u4e3b\u7ad9", true, "68040", "151", true),
    MONGO_PDB(31, "\u8292\u679cPDB", true, "61642", "152", false),
    I_FLY_TEK(32, "IFlyTek", false, "82110", "153", false),
    INMOBI(33, "inmobi", false, "82147", "154", false),
    QUTOUTIAO_NOVEL(34, "\u8da3\u5934\u6761-\u5c0f\u8bf4\u7cfb\u5217", false, "82701", "157", false),
    FANCY(35, "\u6cdb\u4e3a", false, "83844", "158", false),
    KUAI_SHOU(36, "\u5feb\u624b\u8054\u76df", false, "84766", "159", false),
    XIMALAYA(37, "\u559c\u9a6c\u62c9\u96c5", false, "85431", "165", false),
    QQ_READ(38, "QQ\u9605\u8bfb", false, "80611", "169", false),
    HUAWEI_ALLIANCE(39, "\u534e\u4e3a\u8054\u76df", false, "86153", "170", false),
    YOUKU(40, "\u4f18\u9177", true, "83774", "171", false);

    private Integer type;
    private String name;
    private Boolean needAudit;
    private String mediaId;
    private String groupId;
    private Boolean advertiserNeedAudit;

    private AdxTypeEnum(Integer type, String name, Boolean needAudit, String mediaId, String groupId, Boolean advertiserNeedAudit) {
        this.type = type;
        this.name = name;
        this.needAudit = needAudit;
        this.mediaId = mediaId;
        this.groupId = groupId;
        this.advertiserNeedAudit = advertiserNeedAudit;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getNeedAudit() {
        return this.needAudit;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Boolean getAdvertiserNeedAudit() {
        return this.advertiserNeedAudit;
    }

    public boolean sameAdxType(Integer type) {
        return !Objects.isNull(type) && Objects.equals(this.type, type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type) ? null : (AdxTypeEnum)Stream.of(AdxTypeEnum.values()).filter(item -> Objects.equals(item.getType(), type)).findFirst().orElse(null);
    }

    public static Boolean needAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxType.equals(adxTypeEnum.getType())) continue;
            return adxTypeEnum.getNeedAudit();
        }
        return false;
    }

    public static Boolean contains(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType != adxTypeEnum.getType()) continue;
            return true;
        }
        return false;
    }

    public static AdxTypeEnum getEnumByType(Integer type) {
        for (AdxTypeEnum typeEnum : AdxTypeEnum.values()) {
            if (type != typeEnum.getType()) continue;
            return typeEnum;
        }
        return null;
    }

    public static Integer getAdxType(String adxName) {
        if (StringUtils.isBlank((String)adxName)) {
            return 0;
        }
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxTypeEnum.getName().equals(adxName)) continue;
            return adxTypeEnum.getType();
        }
        return 0;
    }

    public static Boolean advertiserNeedAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxType.equals(adxTypeEnum.getType())) continue;
            return adxTypeEnum.getAdvertiserNeedAudit();
        }
        return false;
    }

    public static List<Integer> getAllTypeList() {
        return Arrays.stream(AdxTypeEnum.values()).mapToInt(e -> e.getType()).boxed().collect(Collectors.toList());
    }

    public static List<Integer> getAllNeedAudit() {
        ArrayList needAudits = Lists.newArrayList();
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxTypeEnum.getNeedAudit().booleanValue()) continue;
            needAudits.add(adxTypeEnum.getType());
        }
        return needAudits;
    }
}

