package cn.com.duiba.tuia.activity.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum ComponentInstanceTypeEnum {
    // 平台搭建 组件类型
    ROOT(4, "根组件"),
    LAYOUT(2, "布局组件"),
    WIDGET(5, "组件辅助器, 提供分裂、拖拽等功能"),
    PACKAGE(6, "组件包"),

    // 程序化活动 组件类型
    BASIC(1, "基础组件"),
    PLAYER(7, "玩法组件"),
    DRAW_V2(8, "激励组件"),
    ENC(9, "增值组件"),
    CHAIN(3, "链路组件，逻辑组件"),
    TUIA_BIZ(101, "定制业务组件"),
    ;
    private Integer code;
    private String desc;

    public static ComponentInstanceTypeEnum getByType(Long type) {
        for (ComponentInstanceTypeEnum value : ComponentInstanceTypeEnum.values()) {
            if (type.equals(value.getCode().longValue())) {
                return value;
            }
        }
        return BASIC;
    }

    public static boolean notRuntimeComponent(Long code) {
        int codeInt = code.intValue();
        return !Objects.equals(ROOT.getCode(), codeInt) &&
                !Objects.equals(LAYOUT.getCode(), codeInt) &&
                !Objects.equals(WIDGET.getCode(), codeInt) &&
                !Objects.equals(PACKAGE.getCode(), codeInt);
    }

    public static boolean isNormalComponent(Long code) {
        int codeInt = code.intValue();
        return
                !Objects.equals(LAYOUT.getCode(), codeInt) &&
                        !Objects.equals(WIDGET.getCode(), codeInt) &&
                        !Objects.equals(PACKAGE.getCode(), codeInt);
    }

}